/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.yaml;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.spi.DefaultError;
import org.netbeans.modules.languages.yaml.YamlStructureItem;
import org.netbeans.modules.parsing.api.Snapshot;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.events.AliasEvent;
import org.snakeyaml.engine.v2.events.Event;
import org.snakeyaml.engine.v2.events.MappingEndEvent;
import org.snakeyaml.engine.v2.events.MappingStartEvent;
import org.snakeyaml.engine.v2.events.ScalarEvent;
import org.snakeyaml.engine.v2.events.SequenceEndEvent;
import org.snakeyaml.engine.v2.events.SequenceStartEvent;
import org.snakeyaml.engine.v2.exceptions.Mark;
import org.snakeyaml.engine.v2.exceptions.ParserException;
import org.snakeyaml.engine.v2.exceptions.ScannerException;
import org.snakeyaml.engine.v2.parser.Parser;
import org.snakeyaml.engine.v2.parser.ParserImpl;
import org.snakeyaml.engine.v2.scanner.Scanner;
import org.snakeyaml.engine.v2.scanner.ScannerImpl;
import org.snakeyaml.engine.v2.scanner.StreamReader;

public class YamlSection {
    private static final LoadSettings SETTINGS = LoadSettings.builder().build();
    final int offset;
    final String source;
    private Parser parser = null;

    YamlSection(int offset, String source) {
        this.offset = offset;
        this.source = source;
    }

    public YamlSection(String source) {
        this(0, source);
    }

    public YamlSection before(int index) {
        return new YamlSection(this.offset, this.source.substring(0, index));
    }

    public YamlSection after(int index) {
        return new YamlSection(this.offset + index, this.source.substring(index));
    }

    public YamlSection trimTail() {
        int index;
        for (index = this.source.length() - 1; index > 0 && Character.isWhitespace(this.source.charAt(index)); --index) {
        }
        while (index > -1 && !Character.isWhitespace(this.source.charAt(index))) {
            --index;
        }
        return this.before(index + 1);
    }

    public YamlSection trimHead() {
        int index;
        for (index = 0; index < this.source.length() && Character.isWhitespace(this.source.charAt(index)); ++index) {
        }
        while (index < this.source.length() && !Character.isWhitespace(this.source.charAt(index))) {
            ++index;
        }
        return this.after(index);
    }

    public boolean isEmpty() {
        return this.source.isEmpty();
    }

    public int length() {
        return this.source.length();
    }

    List<? extends StructureItem> collectItems() {
        if (this.parser != null) {
            throw new IllegalStateException("This YAML segment is already parsed.");
        }
        ArrayList ret = new ArrayList();
        ScannerImpl scanner = new ScannerImpl(SETTINGS, new StreamReader(SETTINGS, this.source));
        this.parser = new ParserImpl(SETTINGS, (Scanner)scanner);
        while (this.parser.hasNext()) {
            YamlStructureItem root = this.processItem();
            if (root == null) continue;
            ret.addAll(root.getNestedItems());
        }
        return ret;
    }

    private YamlStructureItem processItem() {
        YamlStructureItem ret = null;
        block6: while (ret == null && this.parser.hasNext()) {
            switch (this.parser.peekEvent().getEventId()) {
                case MappingStart: {
                    ret = this.processMapping((MappingStartEvent)this.parser.next());
                    continue block6;
                }
                case SequenceStart: {
                    ret = this.processSequence((SequenceStartEvent)this.parser.next());
                    continue block6;
                }
                case Scalar: {
                    ret = this.processScalar((ScalarEvent)this.parser.next());
                    continue block6;
                }
                case Alias: {
                    ret = this.processAlias((AliasEvent)this.parser.next());
                    continue block6;
                }
            }
            this.parser.next();
        }
        return ret;
    }

    private YamlStructureItem processAlias(AliasEvent evt) {
        return new YamlStructureItem.Simple(YamlStructureItem.NodeType.ALIAS, evt.getAlias().getValue(), this.getIndex(evt.getStartMark()), this.getIndex(evt.getEndMark()));
    }

    private YamlStructureItem processScalar(ScalarEvent evt) {
        return new YamlStructureItem.Simple(YamlStructureItem.NodeType.SCALAR, evt.getValue(), this.getIndex(evt.getStartMark()), this.getIndex(evt.getEndMark()));
    }

    private YamlStructureItem processMapping(MappingStartEvent evt) {
        YamlStructureItem.Collection item = new YamlStructureItem.Collection(YamlStructureItem.NodeType.MAP, this.getIndex(evt.getStartMark()));
        while (this.parser.hasNext() && !this.parser.checkEvent(Event.ID.MappingEnd)) {
            YamlStructureItem keyItem = this.processItem();
            YamlStructureItem valueItem = this.processItem();
            item.add(new YamlStructureItem.MapEntry(keyItem, valueItem));
        }
        if (this.parser.hasNext()) {
            MappingEndEvent eevt = (MappingEndEvent)this.parser.next();
            if (evt.isFlow()) {
                item.setEndMark(this.getIndex(eevt.getEndMark()));
            }
        }
        return item;
    }

    private YamlStructureItem processSequence(SequenceStartEvent evt) {
        YamlStructureItem.Collection item = new YamlStructureItem.Collection(YamlStructureItem.NodeType.SEQUENCE, this.getIndex(evt.getStartMark()));
        while (this.parser.hasNext() && !this.parser.checkEvent(Event.ID.SequenceEnd)) {
            item.add(this.processItem());
        }
        if (this.parser.hasNext()) {
            SequenceEndEvent eevt = (SequenceEndEvent)this.parser.next();
            if (evt.isFlow()) {
                item.setEndMark(this.getIndex(eevt.getEndMark()));
            }
        }
        return item;
    }

    DefaultError processException(Snapshot snapshot, ScannerException se) {
        int problemIndex;
        int contextIndex = problemIndex = this.getIndex(se.getProblemMark());
        StringBuilder message = new StringBuilder();
        if (se.getContext() != null) {
            contextIndex = this.getIndex(se.getContextMark());
            message.append(se.getContext()).append(", ");
        }
        message.append(se.getProblem());
        char upper = Character.toUpperCase(message.charAt(0));
        message.setCharAt(0, upper);
        return new DefaultError(null, message.toString(), null, snapshot.getSource().getFileObject(), contextIndex, problemIndex, Severity.ERROR);
    }

    DefaultError processException(Snapshot snapshot, ParserException se) {
        int problemIndex;
        int contextIndex = problemIndex = se.getProblemMark().isPresent() ? this.getIndex(se.getProblemMark()) : 0;
        StringBuilder message = new StringBuilder();
        if (se.getContext() != null) {
            contextIndex = this.getIndex(se.getContextMark());
            message.append(se.getContext()).append(", ");
        }
        message.append(se.getProblem());
        char upper = Character.toUpperCase(message.charAt(0));
        message.setCharAt(0, upper);
        return new DefaultError(null, message.toString(), null, snapshot.getSource().getFileObject(), contextIndex, problemIndex, Severity.ERROR);
    }

    List<YamlSection> splitOnException(ScannerException se) {
        int problemIndex = ((Mark)se.getProblemMark().get()).getIndex();
        if (se.getContextMark().isPresent()) {
            int contextIndex = ((Mark)se.getContextMark().get()).getIndex();
            return this.split(contextIndex, problemIndex);
        }
        return this.split(problemIndex, problemIndex);
    }

    List<YamlSection> splitOnException(ParserException pe) {
        if (pe.getContextMark().isPresent()) {
            int contextIndex = ((Mark)pe.getContextMark().get()).getIndex();
            return this.split(contextIndex, contextIndex);
        }
        int problemIndex = ((Mark)pe.getProblemMark().get()).getIndex();
        return this.split(problemIndex, problemIndex);
    }

    List<YamlSection> split(int a) {
        YamlSection after;
        LinkedList<YamlSection> ret = new LinkedList<YamlSection>();
        YamlSection before = a < this.source.length() ? this.before(a) : this.trimTail();
        YamlSection yamlSection = after = a > 0 ? this.after(a) : this.trimHead();
        if (!after.isEmpty()) {
            ret.add(after);
        }
        if (!before.isEmpty()) {
            ret.add(before);
        }
        return ret;
    }

    List<YamlSection> split(int a, int b) {
        if (a == b) {
            return this.split(a);
        }
        LinkedList<YamlSection> ret = new LinkedList<YamlSection>();
        YamlSection before = this.before(a);
        YamlSection after = this.after(b);
        if (!after.isEmpty()) {
            ret.add(after);
        }
        if (!before.isEmpty()) {
            ret.add(before);
        }
        return ret;
    }

    private int getIndex(Optional<Mark> om) {
        return om.get().getIndex() + this.offset;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + this.offset;
        hash = 79 * hash + Objects.hashCode(this.source);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        YamlSection other = (YamlSection)obj;
        if (this.offset != other.offset) {
            return false;
        }
        return Objects.equals(this.source, other.source);
    }

    public String toString() {
        return "" + this.offset + ":" + this.source;
    }
}

