/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.util.TreePath;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.LoggerNotStaticFinal;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.NbBundle;

public class ThreadDumpStack {
    public static ErrorDescription checkThreadDumpStack(HintContext ctx) {
        TreePath treePath = ctx.getPath();
        CompilationInfo compilationInfo = ctx.getInfo();
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)treePath, (String)NbBundle.getMessage(ThreadDumpStack.class, (String)"MSG_ThreadDumpStack"), (Fix[])new Fix[]{new FixImpl(NbBundle.getMessage(LoggerNotStaticFinal.class, (String)"MSG_ThreadDumpStack_fix"), TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo)).toEditorFix()});
    }

    private static final class FixImpl
    extends JavaFix {
        private final String text;

        public FixImpl(String text, TreePathHandle loggerFieldHandle) {
            super(loggerFieldHandle);
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath tp = ctx.getPath();
            Utilities.removeStatement(wc, tp.getParentPath());
        }
    }
}

