/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.netbeans;

import java.util.AbstractList;
import java.util.List;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.PrimitiveArrayInstance;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsProvider;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;

public class EditorDetailsProvider
extends DetailsProvider.Basic {
    private static final String CHAR_CONTENT = "org.netbeans.modules.editor.lib2.document.CharContent";

    public EditorDetailsProvider() {
        super(CHAR_CONTENT);
    }

    @Override
    public String getDetailsString(String className, Instance instance, Heap heap) {
        if (CHAR_CONTENT.equals(className)) {
            int gapStart = DetailsUtils.getIntFieldValue(instance, "gapStart", -1);
            int gapLength = DetailsUtils.getIntFieldValue(instance, "gapLength", -1);
            PrimitiveArrayInstance buffer = (PrimitiveArrayInstance)instance.getValueOfField("buffer");
            if (gapLength >= 0 && gapLength >= 0 && buffer != null) {
                CharArrayWithGap array = new CharArrayWithGap(buffer, gapStart, gapLength);
                return DetailsUtils.getPrimitiveArrayString((Instance)array, 0, array.getLength(), "", "...");
            }
        }
        return null;
    }

    private class CharArrayWithGap
    implements PrimitiveArrayInstance {
        PrimitiveArrayInstance buffer;
        int gapStart;
        int gapLength;

        private CharArrayWithGap(PrimitiveArrayInstance buf, int start, int length) {
            this.buffer = buf;
            this.gapStart = start;
            this.gapLength = length;
        }

        public int getLength() {
            return this.buffer.getLength() - this.gapLength;
        }

        public List getValues() {
            final List origValues = this.buffer.getValues();
            return new AbstractList(){

                @Override
                public Object get(int index) {
                    return origValues.get(CharArrayWithGap.this.rawOffset(index));
                }

                @Override
                public int size() {
                    return CharArrayWithGap.this.getLength();
                }
            };
        }

        private int rawOffset(int index) {
            return index < this.gapStart ? index : index + this.gapLength;
        }

        public List getFieldValues() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isGCRoot() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public long getInstanceId() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int getInstanceNumber() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public JavaClass getJavaClass() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Instance getNearestGCRootPointer() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public long getReachableSize() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public List getReferences() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public long getRetainedSize() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public long getSize() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public List getStaticFieldValues() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Object getValueOfField(String name) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

