/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test;

import org.springframework.test.AbstractDependencyInjectionSpringContextTests;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Deprecated
public abstract class AbstractTransactionalSpringContextTests
extends AbstractDependencyInjectionSpringContextTests {
    protected PlatformTransactionManager transactionManager;
    private boolean defaultRollback = true;
    private boolean complete = false;
    private int transactionsStarted = 0;
    protected TransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
    protected TransactionStatus transactionStatus;

    public AbstractTransactionalSpringContextTests() {
    }

    public AbstractTransactionalSpringContextTests(String name) {
        super(name);
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setDefaultRollback(boolean defaultRollback) {
        this.defaultRollback = defaultRollback;
    }

    protected boolean isDefaultRollback() {
        return this.defaultRollback;
    }

    protected boolean isRollback() {
        return this.isDefaultRollback();
    }

    protected void preventTransaction() {
        this.transactionDefinition = null;
    }

    protected void setTransactionDefinition(TransactionDefinition customDefinition) {
        this.transactionDefinition = customDefinition;
    }

    protected void onSetUp() throws Exception {
        boolean bl = this.complete = !this.isRollback();
        if (this.transactionManager == null) {
            this.logger.info((Object)"No transaction manager set: test will NOT run within a transaction");
        } else if (this.transactionDefinition == null) {
            this.logger.info((Object)"No transaction definition set: test will NOT run within a transaction");
        } else {
            this.onSetUpBeforeTransaction();
            this.startNewTransaction();
            try {
                this.onSetUpInTransaction();
            }
            catch (Exception ex) {
                this.endTransaction();
                throw ex;
            }
        }
    }

    protected void onSetUpBeforeTransaction() throws Exception {
    }

    protected void onSetUpInTransaction() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onTearDown() throws Exception {
        if (this.transactionStatus != null && !this.transactionStatus.isCompleted()) {
            try {
                this.onTearDownInTransaction();
            }
            finally {
                this.endTransaction();
            }
        }
        if (this.transactionsStarted > 0) {
            this.onTearDownAfterTransaction();
        }
    }

    protected void onTearDownInTransaction() throws Exception {
    }

    protected void onTearDownAfterTransaction() throws Exception {
    }

    protected void setComplete() {
        if (this.transactionManager == null) {
            throw new IllegalStateException("No transaction manager set");
        }
        this.complete = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endTransaction() {
        boolean commit;
        boolean bl = commit = this.complete || !this.isRollback();
        if (this.transactionStatus != null) {
            try {
                if (commit) {
                    this.transactionManager.commit(this.transactionStatus);
                    this.logger.debug((Object)("Committed transaction after execution of test [" + this.getName() + "]."));
                } else {
                    this.transactionManager.rollback(this.transactionStatus);
                    this.logger.debug((Object)("Rolled back transaction after execution of test [" + this.getName() + "]."));
                }
            }
            finally {
                this.transactionStatus = null;
            }
        }
    }

    protected void startNewTransaction() throws TransactionException {
        if (this.transactionStatus != null) {
            throw new IllegalStateException("Cannot start new transaction without ending existing transaction: Invoke endTransaction() before startNewTransaction()");
        }
        if (this.transactionManager == null) {
            throw new IllegalStateException("No transaction manager set");
        }
        this.transactionStatus = this.transactionManager.getTransaction(this.transactionDefinition);
        ++this.transactionsStarted;
        boolean bl = this.complete = !this.isRollback();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Began transaction (" + this.transactionsStarted + "): transaction manager [" + this.transactionManager + "]; rollback [" + this.isRollback() + "]."));
        }
    }
}

