/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.explorer;

import java.awt.Image;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.CompletionStage;
import org.netbeans.modules.java.lsp.server.explorer.TreeViewProvider;
import org.openide.nodes.Node;

public interface TreeNodeRegistry {
    public int registerNode(Node var1, TreeViewProvider var2);

    public void unregisterNode(int var1, Node var2);

    public Node findNode(int var1);

    public TreeViewProvider providerOf(int var1);

    public ImageDataOrIndex imageOrIndex(Image var1);

    public CompletionStage<TreeViewProvider> createProvider(String var1);

    public static class ImageDataOrIndex {
        public URI baseURI;
        public String[] composition;
        public final URI imageURI;
        public final int imageIndex;

        public ImageDataOrIndex(URI imageURI) {
            this.imageURI = imageURI;
            this.imageIndex = -1;
        }

        public ImageDataOrIndex(URI imageUri, int imageIndex) {
            this.imageIndex = imageIndex;
            this.imageURI = imageUri;
        }

        public ImageDataOrIndex(int imageIndex) {
            this.imageIndex = imageIndex;
            this.imageURI = null;
        }

        public ImageDataOrIndex baseURL(URL u) {
            try {
                this.baseURI = u == null ? null : u.toURI();
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex);
            }
            return this;
        }

        public ImageDataOrIndex baseURL(URI u) {
            this.baseURI = u;
            return this;
        }

        public ImageDataOrIndex composition(String[] composition) {
            this.composition = composition;
            return this;
        }
    }
}

