/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ThreadReference;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.DeadlockDetector;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.modules.debugger.jpda.Bundle;
import org.netbeans.modules.debugger.jpda.expr.JDIVariable;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;

public class DeadlockDetectorImpl
extends DeadlockDetector
implements PropertyChangeListener {
    private final Set<JPDAThread> suspendedThreads = new WeakSet();
    private final RequestProcessor rp = new RequestProcessor("Deadlock Detector", 1);
    private final Set<RequestProcessor.Task> unfinishedTasks = new HashSet<RequestProcessor.Task>();
    private Map<Long, Node> monitorToNode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DeadlockDetectorImpl(JPDADebugger debugger) {
        if (!Boolean.valueOf(Bundle.USE_JPDA_DEADLOCK_DETECTOR()).booleanValue()) {
            return;
        }
        debugger.addPropertyChangeListener((PropertyChangeListener)this);
        List threads = debugger.getThreadsCollector().getAllThreads();
        for (JPDAThread thread : threads) {
            ((Customizer)thread).addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)thread));
            if (!thread.isSuspended()) continue;
            Set<JPDAThread> set = this.suspendedThreads;
            synchronized (set) {
                this.suspendedThreads.add(thread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("threadStarted".equals(propName)) {
            JPDAThread thread = (JPDAThread)evt.getNewValue();
            ((Customizer)thread).addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)thread));
        } else if ("suspended".equals(propName)) {
            JPDAThread thread = (JPDAThread)evt.getSource();
            boolean suspended = (Boolean)evt.getNewValue();
            if (suspended) {
                HashSet<JPDAThread> tempSuspThreads;
                Set<JPDAThread> set = this.suspendedThreads;
                synchronized (set) {
                    this.suspendedThreads.add(thread);
                    tempSuspThreads = this.suspendedThreads.size() > 1 ? new HashSet<JPDAThread>(this.suspendedThreads) : null;
                }
                if (tempSuspThreads != null) {
                    final RequestProcessor.Task[] taskPtr = new RequestProcessor.Task[]{null};
                    Set<RequestProcessor.Task> set2 = this.unfinishedTasks;
                    synchronized (set2) {
                        RequestProcessor.Task task = this.rp.post(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Set deadlocks = DeadlockDetectorImpl.this.findDeadlockedThreads(tempSuspThreads);
                                if (deadlocks != null) {
                                    DeadlockDetectorImpl.this.setDeadlocks(deadlocks);
                                }
                                Set set = DeadlockDetectorImpl.this.unfinishedTasks;
                                synchronized (set) {
                                    DeadlockDetectorImpl.this.unfinishedTasks.remove(taskPtr[0]);
                                }
                            }
                        });
                        this.unfinishedTasks.add(task);
                        taskPtr[0] = task;
                    }
                }
            } else {
                Set<JPDAThread> set = this.suspendedThreads;
                synchronized (set) {
                    this.suspendedThreads.remove(thread);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForUnfinishedTasks(long timeout) throws InterruptedException {
        HashSet<RequestProcessor.Task> tasks = new HashSet<RequestProcessor.Task>();
        Set<RequestProcessor.Task> set = this.unfinishedTasks;
        synchronized (set) {
            tasks.addAll(this.unfinishedTasks);
        }
        while (!tasks.isEmpty()) {
            RequestProcessor.Task task = (RequestProcessor.Task)tasks.iterator().next();
            task.waitFinished(timeout);
            tasks.remove(task);
        }
    }

    private Set<DeadlockDetector.Deadlock> findDeadlockedThreads(Collection<JPDAThread> threads) {
        this.buildGraph(threads);
        HashSet<Node> simpleNodesSet = new HashSet<Node>();
        LinkedList<Node> simpleNodesList = new LinkedList<Node>();
        for (Map.Entry<Long, Node> entry : this.monitorToNode.entrySet()) {
            Node node = entry.getValue();
            if (!node.isSimple()) continue;
            simpleNodesSet.add(node);
            simpleNodesList.add(node);
        }
        while (simpleNodesList.size() > 0) {
            Node currNode = (Node)simpleNodesList.removeFirst();
            simpleNodesSet.remove(currNode);
            if (currNode.outgoing != null) {
                currNode.outgoing.removeIncomming(currNode);
                if (currNode.outgoing.isSimple() && !simpleNodesSet.contains(currNode.outgoing)) {
                    simpleNodesSet.add(currNode.outgoing);
                    simpleNodesList.add(currNode.outgoing);
                }
            }
            for (Node node : currNode.incomming) {
                node.setOutgoing(null);
                if (!node.isSimple() || simpleNodesSet.contains(node)) continue;
                simpleNodesSet.add(node);
                simpleNodesList.add(node);
            }
            this.monitorToNode.remove(currNode.ownedMonitor.getUniqueID());
        }
        HashSet<DeadlockDetector.Deadlock> result = null;
        if (!this.monitorToNode.isEmpty()) {
            result = new HashSet<DeadlockDetector.Deadlock>();
            HashSet<Node> nodesSet = new HashSet<Node>(this.monitorToNode.values());
            while (!nodesSet.isEmpty()) {
                ArrayList<JPDAThread> deadlockedThreads = new ArrayList<JPDAThread>(nodesSet.size());
                Node node = (Node)nodesSet.iterator().next();
                nodesSet.remove(node);
                do {
                    deadlockedThreads.add(node.thread);
                } while (nodesSet.remove(node = node.outgoing));
                result.add(this.createDeadlock(deadlockedThreads));
            }
        }
        return result;
    }

    private void buildGraph(Collection<JPDAThread> threads) {
        this.monitorToNode = new HashMap<Long, Node>();
        for (JPDAThread thread : threads) {
            if (thread.getState() == 0) continue;
            ObjectVariable contendedMonitor = thread.getContendedMonitor();
            ObjectVariable[] ownedMonitors = thread.getOwnedMonitors();
            if (contendedMonitor != null && ((JDIVariable)contendedMonitor).getJDIValue() instanceof ThreadReference) {
                ownedMonitors = this.checkForThreadJoin(thread, ownedMonitors);
            }
            if (contendedMonitor == null || ownedMonitors.length == 0) continue;
            Node contNode = this.monitorToNode.get(contendedMonitor.getUniqueID());
            if (contNode == null) {
                contNode = new Node(null, contendedMonitor);
                this.monitorToNode.put(contendedMonitor.getUniqueID(), contNode);
            }
            for (int x = 0; x < ownedMonitors.length; ++x) {
                Node node = this.monitorToNode.get(ownedMonitors[x].getUniqueID());
                if (node == null) {
                    node = new Node(thread, ownedMonitors[x]);
                    this.monitorToNode.put(ownedMonitors[x].getUniqueID(), node);
                } else {
                    if (node.thread != null) continue;
                    node.thread = thread;
                }
                node.setOutgoing(contNode);
                contNode.addIncomming(node);
            }
        }
    }

    private ObjectVariable[] checkForThreadJoin(JPDAThread thread, ObjectVariable[] ownedMonitors) {
        CallStackFrame[] callStack;
        try {
            callStack = thread.getCallStack(0, 2);
        }
        catch (AbsentInformationException ex) {
            return ownedMonitors;
        }
        if (callStack.length < 2) {
            return ownedMonitors;
        }
        if (Thread.class.getName().equals(callStack[1].getClassName()) && "join".equals(callStack[1].getMethodName())) {
            ObjectVariable[] ownedMonitorsWithThread = Arrays.copyOf(ownedMonitors, ownedMonitors.length + 1);
            ownedMonitorsWithThread[ownedMonitors.length] = (ObjectVariable)((JPDAThreadImpl)thread).getDebugger().getVariable(((JPDAThreadImpl)thread).getThreadReference());
            return ownedMonitorsWithThread;
        }
        return ownedMonitors;
    }

    private static class Node {
        JPDAThread thread;
        ObjectVariable ownedMonitor;
        Collection<Node> incomming = new HashSet<Node>();
        Node outgoing = null;

        Node(JPDAThread thread, ObjectVariable ownedMonitor) {
            this.thread = thread;
            this.ownedMonitor = ownedMonitor;
        }

        void setOutgoing(Node node) {
            this.outgoing = node;
        }

        void addIncomming(Node node) {
            this.incomming.add(node);
        }

        void removeIncomming(Node node) {
            this.incomming.remove(node);
        }

        boolean isSimple() {
            return this.outgoing == null || this.incomming.size() == 0;
        }
    }
}

