/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.pluginimporter;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.modules.autoupdate.pluginimporter.ClusterUpdateProvider;
import org.netbeans.modules.autoupdate.pluginimporter.ImportManager;
import org.netbeans.modules.autoupdate.pluginimporter.PluginImporter;
import org.openide.filesystems.FileUtil;
import org.openide.modules.ModuleInstall;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class Installer
extends ModuleInstall {
    public static final String KEY_IMPORT_FROM = "import-from";
    public static final String CODE_NAME = "ClusterUpdateProvider";
    public static final String REMOVED = "_removed";
    private static final Logger LOG = Logger.getLogger(Installer.class.getName());
    private static final Comparator<String> APACHE_VERSION_COMPARATOR = (v1, v2) -> new SpecificationVersion(v1).compareTo((Object)new SpecificationVersion(v2));
    private static final List<String> APACHE_VERSION_TO_CHECK = Arrays.asList(NbBundle.getMessage(Installer.class, (String)"apachenetbeanspreviousversion").split(",")).stream().sorted(APACHE_VERSION_COMPARATOR.reversed()).collect(Collectors.toList());
    private static final List<String> VERSION_TO_CHECK = Arrays.asList(".netbeans/7.1.2", ".netbeans/7.1.1", ".netbeans/7.1", ".netbeans/7.0", ".netbeans/6.9");
    private static final List<String> PRE_APACHE_NEWER_VERSION_TO_CHECK = Arrays.asList("8.2", "8.1", "8.0.2", "8.0.1", "8.0", "7.4", "7.3.1", "7.3", "7.2.1", "7.2");
    private static final List<String> NEWER_VERSION_TO_CHECK = Stream.concat(APACHE_VERSION_TO_CHECK.stream(), PRE_APACHE_NEWER_VERSION_TO_CHECK.stream()).collect(Collectors.toList());
    private static final String IMPORTED = "imported";
    private Runnable doCheck = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            File importFrom = null;
            String from = System.getProperty("plugin.manager.import.from", "");
            Preferences pref = NbPreferences.forModule(Installer.class);
            Preferences au_pref = NbPreferences.root().node("/org/netbeans/modules/autoupdate");
            if (from.length() > 0) {
                importFrom = new File(from);
            } else if (pref.get(Installer.KEY_IMPORT_FROM, null) != null) {
                importFrom = new File(pref.get(Installer.KEY_IMPORT_FROM, ""));
            } else {
                boolean imported;
                importFrom = Installer.checkPreviousOnOsSpecificPlace(NEWER_VERSION_TO_CHECK);
                if (importFrom == null) {
                    importFrom = Installer.checkPrevious(VERSION_TO_CHECK);
                }
                if (!(imported = au_pref.getBoolean(Installer.IMPORTED, false))) {
                    importFrom = null;
                }
            }
            au_pref.putBoolean(Installer.IMPORTED, false);
            if (importFrom == null || !importFrom.exists()) {
                LOG.fine("Nothing to import from " + importFrom);
                return;
            }
            try {
                Preferences p = au_pref.node("ClusterUpdateProvider_removed");
                p.removeNode();
            }
            catch (BackingStoreException ex) {
                LOG.log(Level.INFO, ex.getLocalizedMessage(), ex);
                return;
            }
            UpdateUnitProvider clusterUpdateProvider = null;
            for (UpdateUnitProvider p : UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(false)) {
                if (!Installer.CODE_NAME.contains(p.getName())) continue;
                clusterUpdateProvider = p;
            }
            assert (clusterUpdateProvider != null) : "clusterUpdateProvider must found";
            if (clusterUpdateProvider != null) {
                block20: {
                    try {
                        assert (importFrom != null && importFrom.exists()) : importFrom + " exists.";
                        ClusterUpdateProvider.attachCluster(importFrom);
                        List units = clusterUpdateProvider.getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE});
                        UpdateUnitProviderFactory.getDefault().remove(clusterUpdateProvider);
                        PluginImporter importer = new PluginImporter(units);
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Already installed plugins: " + importer.getInstalledPlugins());
                            LOG.fine("Plugins available on UC: " + importer.getPluginsAvailableToInstall());
                            LOG.fine("Plugins available for import: " + importer.getPluginsToImport());
                        }
                        if (!importer.getBrokenPlugins().isEmpty()) {
                            LOG.info("Plugins for import with broken dependencies: " + importer.getBrokenPlugins());
                        }
                        if (!importer.getPluginsToImport().isEmpty() || !importer.getPluginsAvailableToInstall().isEmpty()) {
                            LOG.info(importer.getPluginsToImport().size() + importer.getPluginsAvailableToInstall().size() + " available plugins for import in " + importFrom);
                            ImportManager notifier = new ImportManager(importFrom, Installer.getUserDir(), importer);
                            notifier.notifyAvailable();
                            break block20;
                        }
                        LOG.fine(importer.getPluginsToImport().size() + importer.getPluginsAvailableToInstall().size() + " available plugins for import in " + importFrom);
                    }
                    catch (Exception x) {
                        try {
                            LOG.log(Level.INFO, x.getLocalizedMessage() + " while importing plugins from " + importFrom, x);
                        }
                        catch (Throwable throwable) {
                            UpdateUnitProviderFactory.getDefault().remove(clusterUpdateProvider);
                            throw throwable;
                        }
                        UpdateUnitProviderFactory.getDefault().remove(clusterUpdateProvider);
                    }
                }
                UpdateUnitProviderFactory.getDefault().remove(clusterUpdateProvider);
            }
        }
    };

    public void restored() {
        if (Boolean.getBoolean("netbeans.full.hack") || Boolean.getBoolean("netbeans.close")) {
            return;
        }
        Preferences au_pref = NbPreferences.root().node("/org/netbeans/modules/autoupdate");
        au_pref.node("ClusterUpdateProvider_removed").putBoolean(REMOVED, true);
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                RequestProcessor.getDefault().post(Installer.this.doCheck, Installer.this.getImportDelay());
            }
        });
    }

    private static File getUserDir() {
        String user = System.getProperty("netbeans.user");
        File userDir = null;
        if (user != null) {
            userDir = FileUtil.normalizeFile((File)new File(user));
        }
        return userDir;
    }

    private static File checkPrevious(List<String> versionsToCheck) {
        String userHome = System.getProperty("user.home");
        if (userHome != null) {
            File userHomeFile = new File(userHome);
            for (String ver : versionsToCheck) {
                File sourceFolder = new File(userHomeFile.getAbsolutePath(), ver);
                if (!sourceFolder.exists() || !sourceFolder.isDirectory()) continue;
                return sourceFolder;
            }
        }
        return null;
    }

    private static File checkPreviousOnOsSpecificPlace(List<String> versionsToCheck) {
        String defaultUserdirRoot = System.getProperty("netbeans.default_userdir_root");
        LOG.log(Level.FINER, "netbeans.default_userdir_root: " + defaultUserdirRoot);
        if (defaultUserdirRoot != null) {
            File userHomeFile = new File(defaultUserdirRoot);
            for (String ver : versionsToCheck) {
                File sourceFolder = new File(userHomeFile.getAbsolutePath(), ver);
                if (!sourceFolder.exists() || !sourceFolder.isDirectory()) continue;
                return sourceFolder;
            }
        }
        return null;
    }

    private int getImportDelay() {
        int delay = 50000;
        String delay_prop = System.getProperty("plugin.manager.import.delay");
        try {
            delay = Integer.parseInt(delay_prop);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return delay;
    }
}

