/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.analysis.ui;

import java.awt.Image;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.analysis.AnalysisResult;
import org.netbeans.modules.analysis.DescriptionReader;
import org.netbeans.modules.analysis.SPIAccessor;
import org.netbeans.modules.analysis.spi.Analyzer;
import org.netbeans.modules.analysis.ui.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.actions.OpenAction;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.text.Line;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.UserQuestionException;
import org.openide.util.lookup.Lookups;

public class Nodes {
    private static final Logger LOG = Logger.getLogger(Nodes.class.getName());
    private static final AttributeRetriever<FileObject> BY_FILE = new AttributeRetriever<FileObject>(){

        @Override
        public FileObject getAttribute(Analyzer.AnalyzerFactory a, ErrorDescription ed) {
            return ed.getFile();
        }
    };
    private static final AttributeRetriever<String> BY_ID = new AttributeRetriever<String>(){

        @Override
        public String getAttribute(Analyzer.AnalyzerFactory a, ErrorDescription ed) {
            return ed.getId();
        }
    };
    private static String[] c = new String[]{"&", "<", ">", "\n", "\""};
    private static String[] tags = new String[]{"&amp;", "&lt;", "&gt;", "<br>", "&quot;"};

    public static Node constructSemiLogicalView(final AnalysisResult errors, final boolean byCategory) {
        return new AbstractNode(Children.create((ChildFactory)new ChildFactory<Node>(){

            protected boolean createKeys(List<Node> toPopulate) {
                Nodes.constructSemiLogicalView(errors, byCategory, toPopulate);
                return true;
            }

            protected Node createNodeForKey(Node key) {
                return key;
            }
        }, (boolean)true));
    }

    private static void constructSemiLogicalView(AnalysisResult errors, boolean byCategory, List<Node> toPopulate) {
        for (Node n : errors.extraNodes) {
            toPopulate.add(n.cloneNode());
        }
        if (!byCategory) {
            toPopulate.addAll(Nodes.constructSemiLogicalViewNodes(new LogicalViewCache(), Nodes.sortErrors(errors.provider2Hints, BY_FILE), errors.errorsToProjects));
        } else {
            Map<String, Map<Analyzer.AnalyzerFactory, List<ErrorDescription>>> byCategoryId = Nodes.sortErrors(errors.provider2Hints, new ByCategoryRetriever(errors.analyzerId2Description.get()));
            ArrayList<4> categoryNodes = new ArrayList<4>(byCategoryId.size());
            LogicalViewCache lvc = new LogicalViewCache();
            for (Map.Entry<String, Map<Analyzer.AnalyzerFactory, List<ErrorDescription>>> categoryEntry : byCategoryId.entrySet()) {
                Map<String, Map<Analyzer.AnalyzerFactory, List<ErrorDescription>>> byId = Nodes.sortErrors(categoryEntry.getValue(), BY_ID);
                ArrayList<Node> warningTypNodes = new ArrayList<Node>(byId.size());
                long categoryWarnings = 0L;
                for (Map.Entry<String, Map<Analyzer.AnalyzerFactory, List<ErrorDescription>>> typeEntry : byId.entrySet()) {
                    Analyzer.AnalyzerFactory analyzer = typeEntry.getValue().keySet().iterator().next();
                    final Image icon = SPIAccessor.ACCESSOR.getAnalyzerIcon(analyzer);
                    Analyzer.WarningDescription wd = typeEntry.getKey() != null ? Nodes.findWarningDescription(errors.analyzerId2Description.get(), analyzer, typeEntry.getKey()) : null;
                    String typeDisplayName = wd != null ? SPIAccessor.ACCESSOR.getWarningDisplayName(wd) : null;
                    long typeWarnings = 0L;
                    for (List<ErrorDescription> v1 : typeEntry.getValue().values()) {
                        typeWarnings += (long)v1.size();
                    }
                    final String typeHtmlDisplayName = (typeDisplayName != null ? Nodes.translate(typeDisplayName) : "Unknown") + " <b>(" + typeWarnings + ")</b>";
                    AbstractNode typeNode = new AbstractNode(Nodes.constructSemiLogicalViewChildren(lvc, Nodes.sortErrors(typeEntry.getValue(), BY_FILE), errors.errorsToProjects)){

                        public Image getIcon(int type) {
                            return icon;
                        }

                        public Image getOpenedIcon(int type) {
                            return icon;
                        }

                        public String getHtmlDisplayName() {
                            return typeHtmlDisplayName;
                        }

                        public Action[] getActions(boolean context) {
                            return new Action[0];
                        }
                    };
                    warningTypNodes.add((Node)typeNode);
                    categoryWarnings += typeWarnings;
                }
                Collections.sort(warningTypNodes, new Comparator<Node>(){

                    @Override
                    public int compare(Node o1, Node o2) {
                        return o1.getDisplayName().compareTo(o2.getDisplayName());
                    }
                });
                Analyzer.AnalyzerFactory analyzer = categoryEntry.getValue().keySet().iterator().next();
                final Image icon = SPIAccessor.ACCESSOR.getAnalyzerIcon(analyzer);
                final String categoryHtmlDisplayName = Nodes.translate(categoryEntry.getKey()) + " <b>(" + categoryWarnings + ")</b>";
                AbstractNode categoryNode = new AbstractNode((Children)new DirectChildren(warningTypNodes)){

                    public Image getIcon(int type) {
                        return icon;
                    }

                    public Image getOpenedIcon(int type) {
                        return icon;
                    }

                    public String getHtmlDisplayName() {
                        return categoryHtmlDisplayName;
                    }

                    public Action[] getActions(boolean context) {
                        return new Action[0];
                    }
                };
                categoryNodes.add(categoryNode);
            }
            Collections.sort(categoryNodes, new Comparator<Node>(){

                @Override
                public int compare(Node o1, Node o2) {
                    return o1.getDisplayName().compareTo(o2.getDisplayName());
                }
            });
            toPopulate.addAll(categoryNodes);
        }
    }

    private static <A> Map<A, Map<Analyzer.AnalyzerFactory, List<ErrorDescription>>> sortErrors(Map<Analyzer.AnalyzerFactory, List<ErrorDescription>> errs, AttributeRetriever<A> attributeRetriever) {
        HashMap sorted = new HashMap();
        for (Map.Entry<Analyzer.AnalyzerFactory, List<ErrorDescription>> e : errs.entrySet()) {
            for (ErrorDescription ed : e.getValue()) {
                ArrayList<ErrorDescription> errors;
                if (ed == null) {
                    LOG.log(Level.FINE, "null ErrorDescription produced by {0} ({1})", new Object[]{SPIAccessor.ACCESSOR.getAnalyzerDisplayName(e.getKey()), e.getKey().getClass()});
                    continue;
                }
                A attribute = attributeRetriever.getAttribute(e.getKey(), ed);
                HashMap<Analyzer.AnalyzerFactory, ArrayList<ErrorDescription>> errorsPerAttributeValue = (HashMap<Analyzer.AnalyzerFactory, ArrayList<ErrorDescription>>)sorted.get(attribute);
                if (errorsPerAttributeValue == null) {
                    errorsPerAttributeValue = new HashMap<Analyzer.AnalyzerFactory, ArrayList<ErrorDescription>>();
                    sorted.put(attribute, errorsPerAttributeValue);
                }
                if ((errors = (ArrayList<ErrorDescription>)errorsPerAttributeValue.get(e.getKey())) == null) {
                    errors = new ArrayList<ErrorDescription>();
                    errorsPerAttributeValue.put(e.getKey(), errors);
                }
                errors.add(ed);
            }
        }
        return sorted;
    }

    private static Analyzer.WarningDescription findWarningDescription(Map<Analyzer.AnalyzerFactory, Map<String, Analyzer.WarningDescription>> analyzerId2Description, Analyzer.AnalyzerFactory a, String id) {
        Map<String, Analyzer.WarningDescription> warnings = analyzerId2Description.get(a);
        return warnings != null ? warnings.get(id) : null;
    }

    private static Children constructSemiLogicalViewChildren(final LogicalViewCache lvc, final Map<FileObject, Map<Analyzer.AnalyzerFactory, List<ErrorDescription>>> errors, final Map<ErrorDescription, Project> errorsToProjects) {
        return Children.create((ChildFactory)new ChildFactory<Node>(){

            protected boolean createKeys(List<Node> toPopulate) {
                toPopulate.addAll(Nodes.constructSemiLogicalViewNodes(lvc, errors, errorsToProjects));
                return true;
            }

            protected Node createNodeForKey(Node key) {
                return key;
            }
        }, (boolean)true);
    }

    private static List<Node> constructSemiLogicalViewNodes(LogicalViewCache lvc, Map<FileObject, Map<Analyzer.AnalyzerFactory, List<ErrorDescription>>> errors, Map<ErrorDescription, Project> errorsToProjects) {
        IdentityHashMap projects = new IdentityHashMap();
        HashMap<FileObject, HashSet<Project>> file2Projects = new HashMap<FileObject, HashSet<Project>>();
        for (Map.Entry<FileObject, Map<Analyzer.AnalyzerFactory, List<ErrorDescription>>> entry : errors.entrySet()) {
            HashMap<FileObject, Map<Analyzer.AnalyzerFactory, List<ErrorDescription>>> projectErrors;
            if (!errorsToProjects.isEmpty()) {
                Iterator<Map.Entry<Analyzer.AnalyzerFactory, List<ErrorDescription>>> iterator = entry.getValue().entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Analyzer.AnalyzerFactory, List<ErrorDescription>> analyzerEntry = iterator.next();
                    Iterator<ErrorDescription> errorIt = analyzerEntry.getValue().iterator();
                    while (errorIt.hasNext()) {
                        ArrayList<ErrorDescription> errorList;
                        HashMap<Analyzer.AnalyzerFactory, ArrayList<ErrorDescription>> analyzerErrors;
                        ErrorDescription error = errorIt.next();
                        Project project = errorsToProjects.get(error);
                        if (project == null) continue;
                        HashSet<Project> inProjects = (HashSet<Project>)file2Projects.get(entry.getKey());
                        if (inProjects == null) {
                            inProjects = new HashSet<Project>();
                            file2Projects.put(entry.getKey(), inProjects);
                        }
                        inProjects.add(project);
                        HashMap projectErrors2 = (HashMap)projects.get(project);
                        if (projectErrors2 == null) {
                            projectErrors2 = new HashMap();
                            projects.put(project, projectErrors2);
                        }
                        if ((analyzerErrors = (HashMap<Analyzer.AnalyzerFactory, ArrayList<ErrorDescription>>)projectErrors2.get(entry.getKey())) == null) {
                            analyzerErrors = new HashMap<Analyzer.AnalyzerFactory, ArrayList<ErrorDescription>>();
                            projectErrors2.put(entry.getKey(), analyzerErrors);
                        }
                        if ((errorList = (ArrayList<ErrorDescription>)analyzerErrors.get(analyzerEntry.getKey())) == null) {
                            errorList = new ArrayList<ErrorDescription>();
                            analyzerErrors.put(analyzerEntry.getKey(), errorList);
                        }
                        errorList.add(error);
                        errorIt.remove();
                    }
                    if (!analyzerEntry.getValue().isEmpty()) continue;
                    iterator.remove();
                }
            }
            if (entry.getValue().isEmpty()) continue;
            FileObject fileObject = entry.getKey();
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (project == null) {
                Logger.getLogger(Nodes.class.getName()).log(Level.WARNING, "Cannot find project for: {0}", FileUtil.getFileDisplayName((FileObject)fileObject));
            }
            if ((projectErrors = (HashMap<FileObject, Map<Analyzer.AnalyzerFactory, List<ErrorDescription>>>)projects.get(project)) == null) {
                projectErrors = new HashMap<FileObject, Map<Analyzer.AnalyzerFactory, List<ErrorDescription>>>();
                projects.put(project, projectErrors);
            }
            projectErrors.put(fileObject, errors.get(fileObject));
        }
        projects.remove(null);
        HashMap<Project, HashSet<FileObject>> needsCacheClean = new HashMap<Project, HashSet<FileObject>>();
        for (Map.Entry entry : file2Projects.entrySet()) {
            if (((Set)entry.getValue()).size() <= 1) continue;
            for (Project p : (Set)entry.getValue()) {
                HashSet<FileObject> filesToClear = (HashSet<FileObject>)needsCacheClean.get(p);
                if (filesToClear == null) {
                    filesToClear = new HashSet<FileObject>();
                    needsCacheClean.put(p, filesToClear);
                }
                filesToClear.add((FileObject)entry.getKey());
            }
        }
        ArrayList<Node> arrayList = new ArrayList<Node>(projects.size());
        for (Project p : projects.keySet()) {
            Set filesToClear = (Set)needsCacheClean.get(p);
            if (filesToClear != null) {
                lvc.file2FileNode.keySet().removeAll(filesToClear);
            }
            arrayList.add(Nodes.constructSemiLogicalView(p, lvc, (Map)projects.get(p)));
        }
        Collections.sort(arrayList, new Comparator<Node>(){

            @Override
            public int compare(Node o1, Node o2) {
                return o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
            }
        });
        return arrayList;
    }

    private static Node constructSemiLogicalView(Project p, LogicalViewCache lvc, Map<FileObject, Map<Analyzer.AnalyzerFactory, List<ErrorDescription>>> errors) {
        Node view = (Node)lvc.project2LogicalViewRootNode.get(p);
        LogicalViewProvider lvp = (LogicalViewProvider)p.getLookup().lookup(LogicalViewProvider.class);
        if (view == null) {
            if (lvp != null) {
                view = lvp.createLogicalView();
            } else {
                try {
                    view = DataObject.find((FileObject)p.getProjectDirectory()).getNodeDelegate();
                }
                catch (DataObjectNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return new AbstractNode(Children.LEAF);
                }
            }
            lvc.project2LogicalViewRootNode.put(p, view);
        }
        int warnings = 0;
        for (Map<Analyzer.AnalyzerFactory, List<ErrorDescription>> v1 : errors.values()) {
            for (List<ErrorDescription> v2 : v1.values()) {
                warnings += v2.size();
            }
        }
        Map<Node, Map<Analyzer.AnalyzerFactory, List<ErrorDescription>>> foundNodes = Nodes.resolveFileNodes(lvp, lvc, view, errors);
        return new Wrapper(view, warnings, foundNodes, true);
    }

    private static Map<Node, Map<Analyzer.AnalyzerFactory, List<ErrorDescription>>> resolveFileNodes(LogicalViewProvider lvp, LogicalViewCache lvc, Node view, Map<FileObject, Map<Analyzer.AnalyzerFactory, List<ErrorDescription>>> errors) {
        HashMap<Node, Map<Analyzer.AnalyzerFactory, List<ErrorDescription>>> fileNodes = new HashMap<Node, Map<Analyzer.AnalyzerFactory, List<ErrorDescription>>>();
        for (FileObject file : errors.keySet()) {
            Map<Analyzer.AnalyzerFactory, List<ErrorDescription>> eds = errors.get(file);
            Node foundChild = (Node)lvc.file2FileNode.get(file);
            if (foundChild == null) {
                foundChild = Nodes.locateChild(view, lvp, file);
                if (foundChild == null) {
                    try {
                        foundChild = DataObject.find((FileObject)file).getNodeDelegate();
                    }
                    catch (DataObjectNotFoundException ex) {
                        LOG.log(Level.FINE, null, ex);
                        continue;
                    }
                }
                lvc.file2FileNode.put(file, foundChild);
            }
            if (foundChild == null) {
                return null;
            }
            fileNodes.put(foundChild, eds);
        }
        return fileNodes;
    }

    private static Node locateChild(Node parent, LogicalViewProvider lvp, FileObject file) {
        if (lvp != null) {
            return lvp.findPath(parent, (Object)file);
        }
        throw new UnsupportedOperationException("Not done yet");
    }

    private static Lookup lookupForFileNode(Node n, Map<Analyzer.AnalyzerFactory, List<ErrorDescription>> errors) {
        return Lookups.fixed((Object[])new Object[0]);
    }

    private static boolean isParent(Node parent, Node child) {
        if (NodeOp.isSon((Node)parent, (Node)child)) {
            return true;
        }
        Node p = child.getParentNode();
        if (p == null) {
            return false;
        }
        return Nodes.isParent(parent, p);
    }

    static void openErrorDescription(Analyzer.AnalyzerFactory analyzer, ErrorDescription ed) throws IndexOutOfBoundsException {
        try {
            DataObject od = DataObject.find((FileObject)ed.getFile());
            LineCookie lc = (LineCookie)od.getLookup().lookup(LineCookie.class);
            if (lc != null) {
                Line line = lc.getLineSet().getCurrent(ed.getRange().getBegin().getLine());
                line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                analyzer.warningOpened(ed);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)Exceptions.attachLocalizedMessage((Throwable)((IOException)Exceptions.attachSeverity((Throwable)ex, (Level)Level.WARNING)), (String)Bundle.ERR_CannotOpen()));
        }
    }

    private static String translate(String input) {
        for (int cntr = 0; cntr < c.length; ++cntr) {
            input = input.replaceAll(c[cntr], tags[cntr]);
        }
        return input;
    }

    public static final class LogicalViewCache {
        private final Map<Project, Node> project2LogicalViewRootNode = new IdentityHashMap<Project, Node>();
        private final Map<FileObject, Node> file2FileNode = new HashMap<FileObject, Node>();
    }

    static interface FutureValue<T> {
        public T get();
    }

    private static final class OpenErrorDescription
    implements OpenCookie {
        private final Analyzer.AnalyzerFactory analyzer;
        private final ErrorDescription ed;

        public OpenErrorDescription(Analyzer.AnalyzerFactory analyzer, ErrorDescription ed) {
            this.analyzer = analyzer;
            this.ed = ed;
        }

        public void open() {
            Nodes.openErrorDescription(this.analyzer, this.ed);
        }
    }

    private static final class ErrorDescriptionNode
    extends AbstractNode {
        private final Image icon;

        public ErrorDescriptionNode(Analyzer.AnalyzerFactory provider, final ErrorDescription ed) {
            super(Children.LEAF, Lookups.fixed((Object[])new Object[]{ed, new OpenErrorDescription(provider, ed), new DescriptionReader(){

                @Override
                public CharSequence getDescription() {
                    return ed.getDetails();
                }
            }}));
            int line = -1;
            try {
                PositionBounds range = ed.getRange();
                if (range != null) {
                    line = range.getBegin().getLine();
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.setDisplayName((line != -1 ? line + 1 + ":" : "") + ed.getDescription());
            this.icon = SPIAccessor.ACCESSOR.getAnalyzerIcon(provider);
        }

        public Action getPreferredAction() {
            return OpenAction.get(OpenAction.class);
        }

        public Image getIcon(int type) {
            return this.icon;
        }

        public Action[] getActions(boolean context) {
            return new Action[0];
        }
    }

    private static final class ErrorDescriptionChildren
    extends Children.Keys<ErrorDescription> {
        private final Map<ErrorDescription, Analyzer.AnalyzerFactory> error2Analyzer = new HashMap<ErrorDescription, Analyzer.AnalyzerFactory>();

        public ErrorDescriptionChildren(Map<Analyzer.AnalyzerFactory, List<ErrorDescription>> errors) {
            ArrayList<ErrorDescription> eds = new ArrayList<ErrorDescription>();
            for (Map.Entry<Analyzer.AnalyzerFactory, List<ErrorDescription>> e : errors.entrySet()) {
                for (ErrorDescription ed : e.getValue()) {
                    this.error2Analyzer.put(ed, e.getKey());
                    eds.add(ed);
                }
            }
            Collections.sort(eds, new Comparator<ErrorDescription>(){

                @Override
                public int compare(ErrorDescription o1, ErrorDescription o2) {
                    try {
                        try {
                            PositionBounds r1 = o1.getRange();
                            PositionBounds r2 = o2.getRange();
                            if (r1 != null) {
                                return r2 != null ? r1.getBegin().getLine() - r2.getBegin().getLine() : -1;
                            }
                            return r2 != null ? 1 : o1.getDescription().compareTo(o2.getDescription());
                        }
                        catch (UserQuestionException uqe) {
                            uqe.confirmed();
                            return this.compare(o1, o2);
                        }
                    }
                    catch (IOException ex) {
                        throw new IllegalStateException(ex);
                    }
                }
            });
            this.setKeys(eds);
        }

        protected Node[] createNodes(ErrorDescription key) {
            Analyzer.AnalyzerFactory analyzerFactory = this.error2Analyzer.get(key);
            if (analyzerFactory == null) {
                return null;
            }
            return new Node[]{new ErrorDescriptionNode(analyzerFactory, key)};
        }
    }

    private static final class DirectChildren
    extends Children.Keys<Node> {
        public DirectChildren(Collection<Node> nodes) {
            this.setKeys(nodes);
        }

        protected Node[] createNodes(Node key) {
            return new Node[]{key};
        }
    }

    private static class WrapperChildren
    extends Children.Keys<Node> {
        private final Node orig;
        private final Map<Node, Map<Analyzer.AnalyzerFactory, List<ErrorDescription>>> fileNodes;
        private final List<Node> extraNodes;

        public WrapperChildren(Node orig, Map<Node, Map<Analyzer.AnalyzerFactory, List<ErrorDescription>>> fileNodes, boolean topLevel) {
            this.orig = orig;
            this.fileNodes = fileNodes;
            if (topLevel) {
                this.extraNodes = new ArrayList<Node>();
                for (Node n : fileNodes.keySet()) {
                    if (Nodes.isParent(orig, n)) continue;
                    this.extraNodes.add(n);
                }
            } else {
                this.extraNodes = Collections.emptyList();
            }
        }

        protected void addNotify() {
            if (this.extraNodes.isEmpty()) {
                this.setKeys(this.orig.getChildren().getNodes(true));
            } else {
                ArrayList<Node> children = new ArrayList<Node>();
                children.addAll(Arrays.asList(this.orig.getChildren().getNodes(true)));
                children.addAll(this.extraNodes);
                this.setKeys(children);
            }
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptyList());
        }

        protected synchronized Node[] createNodes(Node key) {
            if (this.fileNodes.containsKey(key)) {
                return new Node[]{new Wrapper(key, this.fileNodes.get(key), true)};
            }
            HashMap<Node, Map<Analyzer.AnalyzerFactory, List<ErrorDescription>>> fileNodesInside = new HashMap<Node, Map<Analyzer.AnalyzerFactory, List<ErrorDescription>>>();
            int warnings = 0;
            for (Map.Entry<Node, Map<Analyzer.AnalyzerFactory, List<ErrorDescription>>> e : this.fileNodes.entrySet()) {
                if (!Nodes.isParent(key, e.getKey())) continue;
                fileNodesInside.put(e.getKey(), e.getValue());
                for (List<ErrorDescription> w : e.getValue().values()) {
                    warnings += w.size();
                }
            }
            if (fileNodesInside.isEmpty()) {
                return new Node[0];
            }
            return new Node[]{new Wrapper(key, warnings, fileNodesInside, false)};
        }
    }

    private static class Wrapper
    extends FilterNode {
        private final int warningsCount;
        private String displayName;
        private String htmlDisplayName;

        public Wrapper(Node orig, int warningsCount, Map<Node, Map<Analyzer.AnalyzerFactory, List<ErrorDescription>>> fileNodes, boolean topLevel) {
            super(orig, (Children)new WrapperChildren(orig, fileNodes, topLevel), Lookup.EMPTY);
            this.warningsCount = warningsCount;
        }

        public Wrapper(Node orig, Map<Analyzer.AnalyzerFactory, List<ErrorDescription>> errors, boolean file) {
            super(orig, (Children)new ErrorDescriptionChildren(errors), Nodes.lookupForFileNode(orig, errors));
            int warnings = 0;
            for (List<ErrorDescription> e : errors.values()) {
                warnings += e.size();
            }
            this.warningsCount = warnings;
        }

        public Action[] getActions(boolean context) {
            return new Action[0];
        }

        public String getDisplayName() {
            if (this.displayName == null) {
                return this.getOriginal().getDisplayName();
            }
            return this.displayName;
        }

        public String getHtmlDisplayName() {
            if (this.htmlDisplayName == null) {
                if (this.getOriginal().getHtmlDisplayName() == null) {
                    return Nodes.translate(this.getOriginal().getDisplayName()) + " <b>(" + this.warningsCount + ")</b>";
                }
                return this.getOriginal().getHtmlDisplayName() + " <b>(" + this.warningsCount + ")</b>";
            }
            return this.htmlDisplayName;
        }

        private void fireDisplayNameChange() {
            this.fireDisplayNameChange(null, this.getDisplayName());
        }
    }

    private static final class ByCategoryRetriever
    implements AttributeRetriever<String> {
        private final Map<Analyzer.AnalyzerFactory, Map<String, Analyzer.WarningDescription>> analyzerId2Description;

        public ByCategoryRetriever(Map<Analyzer.AnalyzerFactory, Map<String, Analyzer.WarningDescription>> analyzerId2Description) {
            this.analyzerId2Description = analyzerId2Description;
        }

        @Override
        public String getAttribute(Analyzer.AnalyzerFactory a, ErrorDescription ed) {
            String id = ed.getId();
            if (id == null) {
                Logger.getLogger(Nodes.class.getName()).log(Level.FINE, "No ID for: {0}", ed.toString());
                return "Unknown";
            }
            Analyzer.WarningDescription wd = Nodes.findWarningDescription(this.analyzerId2Description, a, id);
            if (wd == null) {
                return "Unknown";
            }
            return SPIAccessor.ACCESSOR.getWarningCategoryDisplayName(wd);
        }
    }

    private static interface AttributeRetriever<A> {
        public A getAttribute(Analyzer.AnalyzerFactory var1, ErrorDescription var2);
    }
}

