/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut;

import java.util.LinkedHashMap;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataGroup;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataRepository;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataRepositoryJsonBuilder;

public final class MicronautConfigProperties {
    private static final String CONFIG_METADATA_JSON = "META-INF/spring-configuration-metadata.json";

    private MicronautConfigProperties() {
    }

    public static boolean hasConfigMetadata(Project project) {
        ClassPath cp = MicronautConfigProperties.getExecuteClasspath(project);
        return cp != null && !cp.findAllResources(CONFIG_METADATA_JSON).isEmpty();
    }

    public static Map<String, ConfigurationMetadataProperty> getProperties(Project project) {
        LinkedHashMap<String, ConfigurationMetadataProperty> props = new LinkedHashMap<String, ConfigurationMetadataProperty>();
        ClassPath cp = MicronautConfigProperties.getExecuteClasspath(project);
        if (cp != null) {
            for (FileObject fo : cp.findAllResources(CONFIG_METADATA_JSON)) {
                try {
                    ConfigurationMetadataRepository repository = ConfigurationMetadataRepositoryJsonBuilder.create().withJsonResource(fo.getInputStream()).build();
                    props.putAll(repository.getAllProperties());
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return props;
    }

    public static Map<String, ConfigurationMetadataGroup> getGroups(Project project) {
        LinkedHashMap<String, ConfigurationMetadataGroup> groups = new LinkedHashMap<String, ConfigurationMetadataGroup>();
        ClassPath cp = MicronautConfigProperties.getExecuteClasspath(project);
        if (cp != null) {
            for (FileObject fo : cp.findAllResources(CONFIG_METADATA_JSON)) {
                try {
                    ConfigurationMetadataRepository repository = ConfigurationMetadataRepositoryJsonBuilder.create().withJsonResource(fo.getInputStream()).build();
                    groups.putAll(repository.getAllGroups());
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return groups;
    }

    private static ClassPath getExecuteClasspath(Project project) {
        SourceGroup[] srcGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (srcGroups.length > 0) {
            return ClassPath.getClassPath((FileObject)srcGroups[0].getRootFolder(), (String)"classpath/execute");
        }
        return null;
    }
}

