/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.select;

import org.jsoup.helper.Validate;
import org.jsoup.nodes.Element;
import org.jsoup.select.Collector;
import org.jsoup.select.Elements;
import org.jsoup.select.Evaluator;
import org.jsoup.select.QueryParser;

public class Selector {
    public static Elements select(String query, Element root) {
        Validate.notEmpty(query);
        return Selector.select(QueryParser.parse(query), root);
    }

    public static Elements select(Evaluator evaluator, Element root) {
        Validate.notNull(evaluator);
        Validate.notNull(root);
        return Collector.collect(evaluator, root);
    }

    public static class SelectorParseException
    extends IllegalStateException {
        public SelectorParseException(String msg, Object ... params) {
            super(String.format(msg, params));
        }
    }
}

