/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analyzer;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.ModuleInfo;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J*\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/analyzer/DiagnoseUnknownModuleInfoReporter;", "", "()V", "errorInLibrariesResolver", "", "message", "", "errorInModulesResolver", "errorInModulesResolverWithEmptyInfos", "errorInModulesResolverWithLibraryInfo", "errorInModulesResolverWithScriptDependencies", "errorInScriptDependenciesInfoResolver", "errorInScriptModuleInfoResolver", "errorInSdkResolver", "errorInSpecialModuleInfoResolver", "otherError", "report", "name", "infos", "", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "allModules", "", "frontend"})
final class DiagnoseUnknownModuleInfoReporter {
    @NotNull
    public static final DiagnoseUnknownModuleInfoReporter INSTANCE = new DiagnoseUnknownModuleInfoReporter();

    private DiagnoseUnknownModuleInfoReporter() {
    }

    @NotNull
    public final Void report(@NotNull String name, @NotNull List<? extends ModuleInfo> infos, @NotNull Collection<? extends ModuleInfo> allModules2) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(infos, "infos");
        Intrinsics.checkNotNullParameter(allModules2, "allModules");
        String message = name + " does not know how to resolve " + infos + ", allModules: " + allModules2;
        if (StringsKt.contains$default((CharSequence)name, "sdk", false, 2, null)) {
            this.errorInSdkResolver(message);
            throw null;
        }
        if (StringsKt.contains$default((CharSequence)name, "project libraries", false, 2, null)) {
            this.errorInLibrariesResolver(message);
            throw null;
        }
        if (StringsKt.contains$default((CharSequence)name, "project source roots and libraries", false, 2, null)) {
            if (infos.isEmpty()) {
                this.errorInModulesResolverWithEmptyInfos(message);
                throw null;
            }
            if (infos.size() == 1) {
                String infoAsString = CollectionsKt.single(infos).toString();
                if (StringsKt.contains$default((CharSequence)infoAsString, "ScriptDependencies", false, 2, null)) {
                    this.errorInModulesResolverWithScriptDependencies(message);
                    throw null;
                }
                if (StringsKt.contains$default((CharSequence)infoAsString, "Library", false, 2, null)) {
                    this.errorInModulesResolverWithLibraryInfo(message);
                    throw null;
                }
                this.errorInModulesResolver(message);
                throw null;
            }
            this.errorInModulesResolver(message);
            throw null;
        }
        if (StringsKt.contains$default((CharSequence)name, "dependencies of scripts", false, 2, null)) {
            this.errorInScriptDependenciesInfoResolver(message);
            throw null;
        }
        if (StringsKt.contains$default((CharSequence)name, "completion/highlighting in ", false, 2, null)) {
            if (StringsKt.contains$default((CharSequence)name, "ScriptModuleInfo", false, 2, null)) {
                this.errorInScriptModuleInfoResolver(message);
                throw null;
            }
            this.errorInSpecialModuleInfoResolver(message);
            throw null;
        }
        this.otherError(message);
        throw null;
    }

    private final Void errorInSdkResolver(String message) {
        throw new AssertionError((Object)message);
    }

    private final Void errorInLibrariesResolver(String message) {
        throw new AssertionError((Object)message);
    }

    private final Void errorInModulesResolver(String message) {
        throw new AssertionError((Object)message);
    }

    private final Void errorInModulesResolverWithEmptyInfos(String message) {
        throw new AssertionError((Object)message);
    }

    private final Void errorInModulesResolverWithScriptDependencies(String message) {
        throw new AssertionError((Object)message);
    }

    private final Void errorInModulesResolverWithLibraryInfo(String message) {
        throw new AssertionError((Object)message);
    }

    private final Void errorInScriptDependenciesInfoResolver(String message) {
        throw new AssertionError((Object)message);
    }

    private final Void errorInScriptModuleInfoResolver(String message) {
        throw new AssertionError((Object)message);
    }

    private final Void errorInSpecialModuleInfoResolver(String message) {
        throw new AssertionError((Object)message);
    }

    private final Void otherError(String message) {
        throw new AssertionError((Object)message);
    }
}

