/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded;

import java.util.ArrayList;
import java.util.List;
import org.springsource.loaded.Constants;
import org.springsource.loaded.FieldMember;
import org.springsource.loaded.MethodMember;
import org.springsource.loaded.ReloadableType;
import org.springsource.loaded.TypeRegistry;
import org.springsource.loaded.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeDescriptor
implements Constants {
    private final int modifiers;
    final String typename;
    final String supertypeName;
    final String[] superinterfaceNames;
    private final MethodMember[] constructors;
    private final MethodMember[] methods;
    private final MethodMember[] nonprivateMethods;
    private final FieldMember[] fields;
    private final FieldMember[] fieldsRequiringAccessors;
    private List<String> finalInHierarchy;
    private final TypeRegistry registry;
    private final boolean isReloadable;
    private final boolean hasClinit;
    private static final int IS_GROOVY_TYPE = 1;
    private int bits = 0;
    private ReloadableType reloadableType;
    private int nextId = 0;

    public TypeDescriptor(String slashedTypeName, String supertypeName, String[] superinterfaceNames, int modifiers, List<? extends MethodMember> constructors, List<MethodMember> methods, List<? extends FieldMember> fields, List<? extends FieldMember> fieldsRequiringAccessors, boolean isReloadable, TypeRegistry registry, boolean hasClinit, List<String> finalInHierarchy) {
        this.typename = slashedTypeName;
        this.supertypeName = supertypeName;
        this.superinterfaceNames = superinterfaceNames == null ? NO_STRINGS : superinterfaceNames;
        this.finalInHierarchy = finalInHierarchy;
        this.modifiers = modifiers;
        this.fields = fields.size() == 0 ? FieldMember.NONE : fields.toArray(new FieldMember[fields.size()]);
        this.fieldsRequiringAccessors = fieldsRequiringAccessors.size() == 0 ? FieldMember.NONE : fieldsRequiringAccessors.toArray(new FieldMember[fieldsRequiringAccessors.size()]);
        this.constructors = constructors.size() == 0 ? MethodMember.NONE : constructors.toArray(new MethodMember[constructors.size()]);
        this.methods = methods.size() == 0 ? MethodMember.NONE : methods.toArray(new MethodMember[methods.size()]);
        this.nonprivateMethods = TypeDescriptor.filterNonPrivateMethods(this.methods);
        this.isReloadable = isReloadable;
        this.registry = registry;
        this.hasClinit = hasClinit;
        this.allocateIds();
    }

    private static MethodMember[] filterNonPrivateMethods(MethodMember[] allMethods) {
        ArrayList<MethodMember> result = null;
        for (MethodMember method : allMethods) {
            if (method.isPrivate()) continue;
            if (result == null) {
                result = new ArrayList<MethodMember>();
            }
            result.add(method);
        }
        if (result == null) {
            return MethodMember.NONE;
        }
        return result.toArray(new MethodMember[result.size()]);
    }

    private void allocateIds() {
        for (MethodMember method : this.methods) {
            method.setId(this.nextId++);
        }
    }

    public MethodMember[] getMethods() {
        return this.methods;
    }

    public MethodMember[] getConstructors() {
        return this.constructors;
    }

    public FieldMember[] getFields() {
        return this.fields;
    }

    public FieldMember[] getFieldsRequiringAccessors() {
        return this.fieldsRequiringAccessors;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.typename;
    }

    public String getSupertypeName() {
        return this.supertypeName;
    }

    public String[] getSuperinterfacesName() {
        return this.superinterfaceNames;
    }

    public boolean defines(MethodMember method) {
        for (MethodMember existingMethod : this.methods) {
            if (MethodMember.isCatcher(existingMethod) || !existingMethod.equals(method)) continue;
            return true;
        }
        return false;
    }

    public MethodMember getByDescriptor(String name, String descriptor) {
        for (MethodMember existingMethod : this.methods) {
            if (!existingMethod.getName().equals(name) || !existingMethod.getDescriptor().equals(descriptor)) continue;
            return existingMethod;
        }
        return null;
    }

    public MethodMember getByNameAndDescriptor(String nameAndDescriptor) {
        for (MethodMember existingMethod : this.methods) {
            if (!nameAndDescriptor.startsWith(existingMethod.getName()) || !nameAndDescriptor.endsWith(existingMethod.getDescriptor())) continue;
            return existingMethod;
        }
        return null;
    }

    public boolean isReloadable() {
        return this.isReloadable;
    }

    public MethodMember getMethod(int methodId) {
        return this.methods[methodId];
    }

    public MethodMember getConstructor(int ctorId) {
        return this.constructors[ctorId];
    }

    public boolean isInterface() {
        return (this.modifiers & 0x200) != 0;
    }

    public boolean isAnnotation() {
        return (this.modifiers & 0x2000) != 0;
    }

    public boolean isEnum() {
        return (this.modifiers & 0x4000) != 0;
    }

    public boolean definesNonPrivate(String nameAndDescriptor) {
        for (MethodMember existingMethod : this.nonprivateMethods) {
            if (!existingMethod.nameAndDescriptor.equals(nameAndDescriptor)) continue;
            return true;
        }
        return false;
    }

    public boolean isFinalInHierarchy(String nad) {
        return this.finalInHierarchy.contains(nad);
    }

    public FieldMember getField(String name) {
        for (FieldMember field : this.fields) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public ReloadableType getReloadableType() {
        if (!this.isReloadable) {
            return null;
        }
        if (this.reloadableType == null) {
            this.reloadableType = this.registry.getReloadableType(this.typename);
            if (this.reloadableType == null) {
                throw new IllegalStateException("There is no ReloadableType instance for " + this.typename);
            }
        }
        return this.reloadableType;
    }

    public TypeRegistry getTypeRegistry() {
        return this.registry;
    }

    public String getDottedName() {
        return this.getName().replace('/', '.');
    }

    public MethodMember getConstructor(String desc) {
        for (MethodMember ctor : this.constructors) {
            String d = ctor.getDescriptor();
            if (!d.equals(desc)) continue;
            return ctor;
        }
        return null;
    }

    public boolean isGroovyType() {
        return (this.bits & 1) != 0;
    }

    public void setIsGroovyType(boolean b) {
        this.bits |= 1;
    }

    public boolean hasClinit() {
        return this.hasClinit;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("TypeDescriptor: name=" + this.typename + "  superclass=" + this.supertypeName + "  superinterfaces=" + this.interfacesToString());
        s.append(" flags=0x" + Integer.toHexString(this.modifiers).toUpperCase()).append("\n");
        s.append("Fields: #" + this.fields.length + "\n" + this.fieldsToString());
        s.append("Constructors:#" + this.constructors.length + "\n" + this.methodsToString(this.constructors));
        s.append("Methods:#" + this.methods.length + "\n" + this.methodsToString(this.methods));
        return s.toString();
    }

    private String fieldsToString() {
        StringBuilder s = new StringBuilder();
        int count = 0;
        for (FieldMember field : this.fields) {
            s.append(" field #" + Utils.toPaddedNumber(count++, 3)).append(' ').append(field.toString()).append('\n');
        }
        return s.toString();
    }

    private String interfacesToString() {
        if (this.superinterfaceNames == null) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        for (String superinterfaceName : this.superinterfaceNames) {
            s.append(superinterfaceName);
            s.append(" ");
        }
        return s.toString().trim();
    }

    public String methodsToString(MethodMember[] methods) {
        StringBuilder s = new StringBuilder();
        int count = 0;
        for (MethodMember method : methods) {
            s.append(" method #" + Utils.toPaddedNumber(count++, 3)).append(' ').append(method.toString()).append("   ").append(method.bitsToString()).append('\n');
        }
        return s.toString();
    }
}

