/* ###
 * IP: GHIDRA
 * REVIEWED: YES
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ghidra.program.util;

import ghidra.framework.model.DomainObjectChangeRecord;

/**
 * Event data for a DomainObjectChangeEvent generated by a Data Type Archive.
 * <p>See <a href="doc-files/events.html">Data Type Archive Events</a> for more
 * information on event data.
 *</p>
 */
public class DataTypeArchiveChangeRecord extends DomainObjectChangeRecord {
    private final static long serialVersionUID = 1;

    private Object affectedObj; // may be null

    /**
     * Construct a new DataTypeArchiveChangeRecord; 
     * the <code>affectedObj</code> parameter may be null, 
     * depending on what the <code>type</code> parameter is.
     * @param type event type
     * @param affectedObj the object affected by the change
     * @param oldValue original value
     * @param newValue new value
     */
    public DataTypeArchiveChangeRecord(int type, Object affectedObj, Object oldValue, Object newValue) {
        super(type, oldValue, newValue);
		this.affectedObj = affectedObj;
    }

    /**
     * Return the object that is the subject of this change record.
     *
     * @return Object null if this change record does not have the
     * affected object
     */
    public Object getObject() {
        return affectedObj;
    }
}
