/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.ListenerMap;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;

public class PrivatelyQueuedListener<P> {
    public final P in;
    protected final Executor executor;
    protected final P out;

    public PrivatelyQueuedListener(Class<P> iface, Executor executor, P out) {
        this.in = iface.cast(Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{iface}, (InvocationHandler)new ListenerHandler(iface)));
        this.executor = executor;
        this.out = out;
    }

    public PrivatelyQueuedListener(Class<P> iface, String threadNamePattern, P out) {
        this(iface, Executors.newSingleThreadExecutor((ThreadFactory)new BasicThreadFactory.Builder().namingPattern(threadNamePattern).build()), out);
    }

    protected class ListenerHandler
    implements InvocationHandler {
        protected final Class<P> iface;

        public ListenerHandler(Class<P> iface) {
            this.iface = iface;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            PrivatelyQueuedListener.this.executor.execute(() -> {
                try {
                    method.invoke(PrivatelyQueuedListener.this.out, args);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    ListenerMap.reportError(PrivatelyQueuedListener.this.out, cause);
                }
                catch (Throwable e) {
                    ListenerMap.reportError(PrivatelyQueuedListener.this.out, e);
                }
            });
            return null;
        }
    }
}

