/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;

public abstract class AbstractLongOffsetPcodeExecutorStatePiece<A, T, S>
implements PcodeExecutorStatePiece<A, T> {
    protected final Language language;
    protected final PcodeArithmetic<T> arithmetic;
    protected final AddressSpace uniqueSpace;

    public AbstractLongOffsetPcodeExecutorStatePiece(Language language, PcodeArithmetic<T> arithmetic) {
        this.language = language;
        this.arithmetic = arithmetic;
        this.uniqueSpace = language.getAddressFactory().getUniqueSpace();
    }

    protected void setUnique(long offset, int size, T val) {
        S s = this.getForSpace(this.uniqueSpace, true);
        this.setInSpace(s, offset, size, val);
    }

    protected T getUnique(long offset, int size) {
        S s = this.getForSpace(this.uniqueSpace, false);
        return this.getFromSpace(s, offset, size);
    }

    protected abstract S getForSpace(AddressSpace var1, boolean var2);

    protected abstract void setInSpace(S var1, long var2, int var4, T var5);

    protected abstract T getFromSpace(S var1, long var2, int var4);

    protected T getFromNullSpace(int size) {
        return this.arithmetic.fromConst(0L, size);
    }

    protected abstract long offsetToLong(A var1);

    @Override
    public void setVar(AddressSpace space, A offset, int size, boolean truncateAddressableUnit, T val) {
        this.setVar(space, this.offsetToLong(offset), size, truncateAddressableUnit, val);
    }

    @Override
    public void setVar(AddressSpace space, long offset, int size, boolean truncateAddressableUnit, T val) {
        this.checkRange(space, offset, size);
        if (space.isConstantSpace()) {
            throw new IllegalArgumentException("Cannot write to constant space");
        }
        if (space.isUniqueSpace()) {
            this.setUnique(offset, size, val);
            return;
        }
        S s = this.getForSpace(space, true);
        offset = this.truncateOffset(space, offset);
        this.setInSpace(s, offset, size, val);
    }

    @Override
    public T getVar(AddressSpace space, A offset, int size, boolean truncateAddressableUnit) {
        return this.getVar(space, this.offsetToLong(offset), size, truncateAddressableUnit);
    }

    @Override
    public T getVar(AddressSpace space, long offset, int size, boolean truncateAddressableUnit) {
        this.checkRange(space, offset, size);
        if (space.isConstantSpace()) {
            return this.arithmetic.fromConst(offset, size);
        }
        if (space.isUniqueSpace()) {
            return this.getUnique(offset, size);
        }
        S s = this.getForSpace(space, false);
        if (s == null) {
            return this.getFromNullSpace(size);
        }
        offset = this.truncateOffset(space, offset);
        return this.getFromSpace(s, offset, size);
    }
}

