/*
 * Decompiled with CFR 0.152.
 */
package ghidra.server.security;

import generic.random.SecureRandomFactory;
import java.security.SecureRandom;
import java.util.Date;

public class TokenGenerator {
    static byte[] getNewToken(int size) {
        SecureRandom random = SecureRandomFactory.getSecureRandom();
        byte[] token = new byte[size - 8];
        random.nextBytes(token);
        byte[] stampedToken = new byte[token.length + 8];
        System.arraycopy(token, 0, stampedToken, 8, token.length);
        TokenGenerator.putLong(stampedToken, 0, new Date().getTime());
        return stampedToken;
    }

    static boolean isRecentToken(byte[] token, long maxTime) {
        if (token.length < 8) {
            return false;
        }
        long diff = new Date().getTime() - TokenGenerator.getLong(token, 0);
        return diff >= 0L && diff < maxTime;
    }

    private static long getLong(byte[] data, int offset) {
        return ((long)data[offset] & 0xFFL) << 56 | ((long)data[++offset] & 0xFFL) << 48 | ((long)data[++offset] & 0xFFL) << 40 | ((long)data[++offset] & 0xFFL) << 32 | ((long)data[++offset] & 0xFFL) << 24 | ((long)data[++offset] & 0xFFL) << 16 | ((long)data[++offset] & 0xFFL) << 8 | (long)data[++offset] & 0xFFL;
    }

    private static int putLong(byte[] data, int offset, long v) {
        data[offset] = (byte)(v >> 56);
        data[++offset] = (byte)(v >> 48);
        data[++offset] = (byte)(v >> 40);
        data[++offset] = (byte)(v >> 32);
        data[++offset] = (byte)(v >> 24);
        data[++offset] = (byte)(v >> 16);
        data[++offset] = (byte)(v >> 8);
        data[++offset] = (byte)v;
        return ++offset;
    }
}

