/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.util;

import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public enum CollectionUtils {


    public static <K, V> Collection<V> getAllExisting(Map<K, V> map, Collection<K> keys) {
        ArrayList<V> result = new ArrayList<V>();
        for (K k : keys) {
            if (!map.containsKey(k)) continue;
            result.add(map.get(k));
        }
        return result;
    }

    public static class Delta<T, U extends T> {
        public static final Delta<?, ?> EMPTY = new Delta(Map.of(), Map.of());
        public static final BiPredicate<Object, Object> SAME = (a, b) -> a == b;
        public static final BiPredicate<Object, Object> EQUAL = Objects::equals;
        public final Map<String, T> removed;
        public final Map<String, U> added;
        private volatile Set<String> keysRemoved;

        public static final <T, U extends T> Delta<T, U> empty() {
            return EMPTY;
        }

        public static final <T, U extends T> Delta<T, U> create(Map<String, T> removed, Map<String, U> added) {
            return new Delta<T, U>(removed, added);
        }

        public static final <T, U extends T> Delta<T, U> create(Collection<String> removedKeys, Map<String, U> added) {
            HashMap<String, Object> removedNull = new HashMap<String, Object>();
            for (String key : removedKeys) {
                removedNull.put(key, null);
            }
            return new Delta(removedNull, added);
        }

        protected static final <T> void retainKeys(Map<String, T> mutable, Collection<String> keys, Map<String, T> removed) {
            Iterator<Map.Entry<String, T>> eit = mutable.entrySet().iterator();
            while (eit.hasNext()) {
                Map.Entry<String, T> oldEnt = eit.next();
                if (keys.contains(oldEnt.getKey())) continue;
                removed.put(oldEnt.getKey(), oldEnt.getValue());
                eit.remove();
            }
        }

        protected static final <T> void removeKeys(Map<String, T> mutable, Collection<String> keys, Map<String, T> removed) {
            for (String r : keys) {
                if (!mutable.containsKey(r)) continue;
                removed.put(r, mutable.remove(r));
            }
        }

        protected static final <T, U extends T> void putEntries(Map<String, T> mutable, Map<String, U> entries, Map<String, T> removed, Map<String, U> added, BiPredicate<? super T, ? super U> equals) {
            for (Map.Entry<String, U> e : entries.entrySet()) {
                String key = e.getKey();
                U newVal = e.getValue();
                if (!mutable.containsKey(key)) {
                    mutable.put(key, newVal);
                    added.put(key, newVal);
                    continue;
                }
                T oldVal = mutable.get(key);
                if (equals.test(oldVal, newVal)) continue;
                mutable.put(key, newVal);
                removed.put(key, oldVal);
                added.put(key, newVal);
            }
        }

        public static final <T, U extends T> Delta<T, U> computeAndSet(Map<String, T> mutable, Map<String, U> desired, BiPredicate<? super T, ? super U> equals) {
            LinkedHashMap removed = new LinkedHashMap();
            LinkedHashMap added = new LinkedHashMap();
            Delta.retainKeys(mutable, desired.keySet(), removed);
            Delta.putEntries(mutable, desired, removed, added, equals);
            return Delta.create(removed, added);
        }

        public static final <T, U extends T> Delta<T, U> apply(Map<String, T> mutable, Collection<String> removed, Map<String, U> added, BiPredicate<? super T, ? super U> equals) {
            if (removed.isEmpty() && added.isEmpty()) {
                return Delta.empty();
            }
            LinkedHashMap fRemoved = new LinkedHashMap();
            LinkedHashMap fAdded = new LinkedHashMap();
            Delta.removeKeys(mutable, removed, fRemoved);
            Delta.putEntries(mutable, added, fRemoved, fAdded, equals);
            return Delta.create(fRemoved, fAdded);
        }

        public static final void applyToKeys(Set<String> mutable, Collection<String> removed, Map<String, ?> added) {
            mutable.removeAll(removed);
            mutable.addAll(added.keySet());
        }

        protected Delta(Map<String, T> removed, Map<String, U> added) {
            this.removed = removed;
            this.added = added;
        }

        public String toString() {
            return "<Delta removed=" + this.removed + ", added=" + this.added + ">";
        }

        public boolean isEmpty() {
            return this.removed.isEmpty() && this.added.isEmpty();
        }

        public Delta<T, U> apply(Map<String, T> mutable, BiPredicate<Object, Object> equals) {
            return Delta.apply(mutable, this.removed.keySet(), this.added, equals);
        }

        public Delta<T, U> apply(Map<String, T> mutable) {
            return this.apply(mutable, SAME);
        }

        public void applyToKeys(Set<String> mutable) {
            Delta.applyToKeys(mutable, this.removed.keySet(), this.added);
        }

        public Set<String> getKeysRemoved() {
            if (this.keysRemoved != null) {
                return this.keysRemoved;
            }
            LinkedHashSet<String> temp = new LinkedHashSet<String>(this.removed.keySet());
            temp.removeAll(this.added.keySet());
            this.keysRemoved = temp;
            return this.keysRemoved;
        }
    }

    public static class AbstractNMap<K, V>
    extends AbstractImmutableMap<K, V> {
        protected final Map<K, V> wrapped;

        public AbstractNMap(Map<K, V> map) {
            this.wrapped = Collections.unmodifiableMap(new LinkedHashMap<K, V>(map));
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.wrapped.entrySet();
        }
    }

    public static class AbstractNSet<T>
    extends AbstractImmutableSet<T> {
        protected final Set<T> wrapped;

        @SafeVarargs
        public AbstractNSet(T ... elems) {
            this.wrapped = Set.of(elems);
        }

        public AbstractNSet(Collection<T> col) {
            this.wrapped = Set.copyOf(col);
        }

        @Override
        public Iterator<T> iterator() {
            return this.wrapped.iterator();
        }

        @Override
        public int size() {
            return this.wrapped.size();
        }
    }

    public static class AbstractNList<T>
    extends AbstractImmutableList<T> {
        protected final List<T> wrapped;

        @SafeVarargs
        public AbstractNList(T ... elems) {
            this.wrapped = List.of(elems);
        }

        public AbstractNList(Collection<T> col) {
            this.wrapped = List.copyOf(col);
        }

        @Override
        public T get(int index) {
            return this.wrapped.get(index);
        }

        @Override
        public int size() {
            return this.wrapped.size();
        }
    }

    public static class AbstractEmptySet<T>
    extends AbstractImmutableSet<T> {
        @Override
        public Iterator<T> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public int size() {
            return 0;
        }
    }

    public static class AbstractEmptyList<T>
    extends AbstractList<T> {
        @Override
        public T get(int index) {
            throw new ArrayIndexOutOfBoundsException(index);
        }

        @Override
        public int size() {
            return 0;
        }
    }

    public static class AbstractEmptyMap<K, V>
    extends AbstractMap<K, V> {
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return Set.of();
        }
    }

    public static abstract class AbstractImmutableMap<K, V>
    extends AbstractMap<K, V> {
    }

    public static abstract class AbstractImmutableSet<T>
    extends AbstractSet<T> {
        @Override
        public boolean add(T e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    public static abstract class AbstractImmutableList<T>
    extends AbstractList<T> {
        @Override
        public void add(int index, T element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(T e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeIf(Predicate<? super T> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void replaceAll(UnaryOperator<T> operator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T set(int index, T element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void sort(Comparator<? super T> c) {
            throw new UnsupportedOperationException();
        }
    }
}

