/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.impl;

import agent.gdb.manager.GdbRegister;
import agent.gdb.manager.GdbStackFrame;
import agent.gdb.manager.impl.GdbManagerImpl;
import agent.gdb.manager.impl.GdbThreadImpl;
import agent.gdb.manager.impl.cmd.GdbConsoleExecCommand;
import agent.gdb.manager.impl.cmd.GdbEvaluateCommand;
import agent.gdb.manager.impl.cmd.GdbReadRegistersCommand;
import agent.gdb.manager.impl.cmd.GdbSetActiveThreadCommand;
import agent.gdb.manager.impl.cmd.GdbWriteRegistersCommand;
import agent.gdb.manager.parsing.GdbMiParser;
import agent.gdb.manager.parsing.GdbParsingUtils;
import java.math.BigInteger;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class GdbStackFrameImpl
implements GdbStackFrame {
    protected final GdbManagerImpl manager;
    protected final GdbThreadImpl thread;
    protected final int level;
    protected final BigInteger addr;
    protected final String func;

    public static GdbStackFrameImpl fromFieldList(GdbThreadImpl thread, GdbMiParser.GdbMiFieldList fields) {
        String lvlString = fields.getString("level");
        int level = lvlString == null ? 0 : Integer.parseInt(lvlString);
        BigInteger addr = GdbParsingUtils.parsePrefixedHexBig(fields.getString("addr"));
        String func = fields.getString("func");
        return new GdbStackFrameImpl(thread, level, addr, func);
    }

    public GdbStackFrameImpl(GdbThreadImpl thread, int level, BigInteger addr, String func) {
        this.manager = thread.manager;
        this.thread = thread;
        this.level = level;
        this.addr = addr;
        this.func = func;
    }

    public String toString() {
        String strAddr = this.addr == null ? "<null>" : this.addr.toString(16);
        String strFunc = this.func == null ? "<null>" : this.func.toString();
        return "<GdbStackFrame: level=" + this.level + ",addr=0x" + strAddr + ",func='" + strFunc + "'>";
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public BigInteger getAddress() {
        return this.addr;
    }

    @Override
    public String getFunction() {
        return this.func;
    }

    @Override
    public GdbThreadImpl getThread() {
        return this.thread;
    }

    @Override
    public GdbStackFrame fillWith(GdbStackFrame frame) {
        String fFunc;
        if (this.addr != null && this.func != null) {
            return this;
        }
        BigInteger fAddr = this.addr;
        if (fAddr == null) {
            fAddr = frame != null && frame.getAddress() != null ? frame.getAddress() : BigInteger.ZERO;
        }
        if ((fFunc = this.func) == null) {
            fFunc = frame != null && frame.getFunction() != null ? frame.getFunction() : "";
        }
        return new GdbStackFrameImpl(this.thread, this.level, fAddr, fFunc);
    }

    @Override
    public CompletableFuture<Void> setActive(boolean internal) {
        return this.manager.execute(new GdbSetActiveThreadCommand(this.manager, this.thread.getId(), this.level, internal));
    }

    @Override
    public CompletableFuture<String> evaluate(String expression) {
        return this.manager.execute(new GdbEvaluateCommand(this.manager, this.thread.getId(), this.level, expression));
    }

    @Override
    public CompletableFuture<Map<GdbRegister, BigInteger>> readRegisters(Set<GdbRegister> regs) {
        return this.thread.getInferior().syncEndianness().thenCompose(__ -> this.manager.execute(new GdbReadRegistersCommand(this.manager, this.thread, this.level, regs)));
    }

    @Override
    public CompletableFuture<Void> writeRegisters(Map<GdbRegister, BigInteger> regVals) {
        return this.thread.getInferior().syncEndianness().thenCompose(__ -> this.manager.execute(new GdbWriteRegistersCommand(this.manager, this.thread, this.level, regVals)));
    }

    @Override
    public CompletableFuture<Void> console(String command, GdbConsoleExecCommand.CompletesWithRunning cwr) {
        return this.manager.execute(new GdbConsoleExecCommand(this.manager, this.thread.getId(), this.level, command, GdbConsoleExecCommand.Output.CONSOLE, cwr)).thenApply(e -> null);
    }

    @Override
    public CompletableFuture<String> consoleCapture(String command, GdbConsoleExecCommand.CompletesWithRunning cwr) {
        return this.manager.execute(new GdbConsoleExecCommand(this.manager, this.thread.getId(), this.level, command, GdbConsoleExecCommand.Output.CAPTURE, cwr));
    }
}

