/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.symbol;

import db.DBRecord;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.AutoParameterType;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.trace.database.symbol.AbstractDBTraceVariableSymbol;
import ghidra.trace.database.symbol.DBTraceFunctionSymbol;
import ghidra.trace.database.symbol.DBTraceSymbolManager;
import ghidra.trace.model.Trace;
import ghidra.trace.model.symbol.TraceParameterSymbol;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.LockHold;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.exception.InvalidInputException;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

@DBAnnotatedObjectInfo(version=0)
public class DBTraceParameterSymbol
extends AbstractDBTraceVariableSymbol
implements TraceParameterSymbol {
    static final String TABLE_NAME = "Parameters";
    static final String ORDINAL_COLUMN_NAME = "Ordinal";
    @DBAnnotatedColumn(value="Ordinal")
    static DBObjectColumn ORDINAL_COLUMN;
    @DBAnnotatedField(column="Ordinal")
    int ordinal;
    protected VariableStorage dynamicStorage = VariableStorage.UNASSIGNED_STORAGE;

    public DBTraceParameterSymbol(DBTraceSymbolManager manager, DBCachedObjectStore<?> store, DBRecord record) {
        super(manager, store, record);
    }

    protected void set(String name, DBTraceFunctionSymbol function, DataType dt, VariableStorage storage, int ordinal, SourceType source) {
        super.set(name, function, dt, storage, source);
        this.ordinal = ordinal;
        this.update(ORDINAL_COLUMN);
    }

    @Override
    protected VariableStorage adjustStorage(VariableStorage s) {
        if (!this.getFunction().hasCustomVariableStorage()) {
            return VariableStorage.UNASSIGNED_STORAGE;
        }
        return super.adjustStorage(s);
    }

    public SymbolType getSymbolType() {
        return SymbolType.PARAMETER;
    }

    @Override
    protected Pair<String, SourceType> validateNameAndSource(String newName, SourceType newSource) throws InvalidInputException {
        if (newSource == SourceType.DEFAULT || newName == null || "".equals(newName) || SymbolUtilities.isDefaultParameterName((String)newName)) {
            return new ImmutablePair((Object)"", (Object)SourceType.DEFAULT);
        }
        return new ImmutablePair((Object)newName, (Object)newSource);
    }

    @Override
    public String getName() {
        if (this.getSource() == SourceType.DEFAULT && this.ordinal != -1) {
            return SymbolUtilities.getDefaultParamName((int)this.ordinal);
        }
        return super.getName();
    }

    @Override
    public DBTraceFunctionSymbol getParentNamespace() {
        return (DBTraceFunctionSymbol)super.getParentNamespace();
    }

    @Override
    public DBTraceFunctionSymbol getParentSymbol() {
        return (DBTraceFunctionSymbol)super.getParentSymbol();
    }

    @Override
    public DBTraceFunctionSymbol getFunction() {
        return this.getParentSymbol();
    }

    public boolean setPrimary() {
        return false;
    }

    public boolean isPrimary() {
        return false;
    }

    @Override
    public VariableStorage getVariableStorage() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            if (!this.getFunction().hasCustomVariableStorage()) {
                VariableStorage variableStorage = this.dynamicStorage;
                return variableStorage;
            }
            VariableStorage variableStorage = super.getVariableStorage();
            return variableStorage;
        }
    }

    public void setOrdinal(int ordinal) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            this.ordinal = ordinal;
            this.update(ORDINAL_COLUMN);
        }
    }

    public int getOrdinal() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            int n = this.ordinal;
            return n;
        }
    }

    public boolean isAutoParameter() {
        return false;
    }

    public AutoParameterType getAutoParameterType() {
        return null;
    }

    public boolean isForcedIndirect() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            VariableStorage s = this.getVariableStorage();
            boolean bl = s == null ? false : s.isForcedIndirect();
            return bl;
        }
    }

    @Override
    public DataType getDataType() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            DataType dataType = this.manager.checkIndirection(this.getVariableStorage(), this.getFormalDataType());
            return dataType;
        }
    }

    public DataType getFormalDataType() {
        return super.getDataType();
    }

    public int getFirstUseOffset() {
        return 0;
    }

    protected void doSetDynamicStorage(VariableStorage s) {
        assert (!this.getFunction().hasCustomVariableStorage());
        this.dynamicStorage = s;
    }

    @Override
    protected void doUpdatesAfterSetDataType() {
        super.doUpdatesAfterSetDataType();
        DBTraceFunctionSymbol function = this.getFunction();
        if (!function.hasCustomVariableStorage()) {
            function.doUpdateParametersAndReturn();
        }
        function.doUpdateSignatureSourceAfterVariableChange(this.getSource(), this.getDataType());
        if (this.ordinal == -1) {
            this.manager.trace.setChanged(new TraceChangeRecord(Trace.TraceFunctionChangeType.CHANGED_RETURN, this.getSpace(), this.getFunction()));
        } else {
            this.manager.trace.setChanged(new TraceChangeRecord(Trace.TraceFunctionChangeType.CHANGED_PARAMETERS, this.getSpace(), this.getFunction()));
        }
    }

    @Override
    protected VariableStorage doDeriveStorageForSetDataType(DataType dt, boolean alignStack, boolean force) throws InvalidInputException {
        if (!this.getFunction().hasCustomVariableStorage()) {
            return VariableStorage.UNASSIGNED_STORAGE;
        }
        return super.doDeriveStorageForSetDataType(dt, alignStack, force);
    }

    @Override
    public boolean delete() {
        if (super.delete()) {
            this.manager.trace.setChanged(new TraceChangeRecord(Trace.TraceFunctionChangeType.CHANGED_PARAMETERS, this.getSpace(), this.getFunction()));
            return true;
        }
        return false;
    }
}

