/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.symbol;

import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolType;
import ghidra.trace.database.symbol.AbstractDBTraceSymbolSingleTypeView;
import ghidra.trace.database.symbol.DBTraceNamespaceSymbol;
import ghidra.trace.database.symbol.DBTraceSymbolManager;
import ghidra.trace.model.Trace;
import ghidra.trace.model.symbol.TraceNamespaceSymbol;
import ghidra.trace.model.symbol.TraceNamespaceSymbolView;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.LockHold;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.locks.Lock;

public class DBTraceNamespaceSymbolView
extends AbstractDBTraceSymbolSingleTypeView<DBTraceNamespaceSymbol>
implements TraceNamespaceSymbolView {
    public DBTraceNamespaceSymbolView(DBTraceSymbolManager manager) {
        super(manager, SymbolType.NAMESPACE.getID(), manager.namespaceStore);
    }

    @Override
    public DBTraceNamespaceSymbol add(String name, TraceNamespaceSymbol parent, SourceType source) throws DuplicateNameException, InvalidInputException, IllegalArgumentException {
        if (source == SourceType.DEFAULT) {
            throw new IllegalArgumentException();
        }
        DBTraceSymbolManager.assertValidName(name);
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            DBTraceNamespaceSymbol dbnsParent = this.manager.assertIsMine(parent);
            this.manager.assertUniqueName(name, dbnsParent);
            DBTraceNamespaceSymbol namespace = (DBTraceNamespaceSymbol)this.store.create();
            namespace.set(name, dbnsParent, source);
            this.manager.trace.setChanged(new TraceChangeRecord(Trace.TraceSymbolChangeType.ADDED, null, namespace));
            DBTraceNamespaceSymbol dBTraceNamespaceSymbol = namespace;
            return dBTraceNamespaceSymbol;
        }
    }

    @Override
    protected Collection<DBTraceNamespaceSymbol> constructView() {
        return Collections.unmodifiableCollection(this.store.asMap().tailMap(Long.valueOf(1L)).values());
    }
}

