/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.space;

import com.google.common.collect.Range;
import com.google.common.primitives.UnsignedLong;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.trace.database.space.DBTraceSpaceKey;

public interface DBTraceSpaceBased
extends DBTraceSpaceKey {
    default public long assertInSpace(Address addr) {
        if (addr.getAddressSpace() != this.getAddressSpace()) {
            throw new IllegalArgumentException("Address '" + addr + "' is not in this space: '" + this.getAddressSpace() + "'");
        }
        return addr.getOffset();
    }

    default public void assertInSpace(AddressRange range) {
        if (range.getAddressSpace() != this.getAddressSpace()) {
            throw new IllegalArgumentException("Address Range '" + range + "' is not in this space: '" + this.getAddressSpace() + "'");
        }
    }

    default public UnsignedLong toOffset(Address address) {
        return UnsignedLong.fromLongBits((long)address.getOffset());
    }

    default public Range<UnsignedLong> toOffsetRange(AddressRange range) {
        return Range.closed((Comparable)this.toOffset(range.getMinAddress()), (Comparable)this.toOffset(range.getMaxAddress()));
    }

    default public Address toAddress(UnsignedLong offset) {
        return this.getAddressSpace().getAddress(offset.longValue());
    }

    default public Address toAddress(long offset) {
        return this.getAddressSpace().getAddress(offset);
    }

    default public AddressRange toAddressRange(Range<UnsignedLong> range) {
        return new AddressRangeImpl(this.toAddress((UnsignedLong)range.lowerEndpoint()), this.toAddress((UnsignedLong)range.upperEndpoint()));
    }

    public void invalidateCache();
}

