/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.listing;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Range;
import db.DBHandle;
import db.DBRecord;
import ghidra.lifecycle.Unfinished;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.InstructionPrototype;
import ghidra.program.model.lang.InvalidPrototype;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.ProcessorContext;
import ghidra.program.model.lang.ProcessorContextView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.DefaultProgramContext;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.mem.ByteMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.util.ProgramContextImpl;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.address.DBTraceOverlaySpaceAdapter;
import ghidra.trace.database.data.DBTraceDataTypeManager;
import ghidra.trace.database.language.DBTraceLanguageManager;
import ghidra.trace.database.listing.AbstractDBTraceCodeUnit;
import ghidra.trace.database.listing.DBTraceCodeRegisterSpace;
import ghidra.trace.database.listing.DBTraceCodeSpace;
import ghidra.trace.database.listing.DBTraceCodeUnitsMemoryView;
import ghidra.trace.database.listing.DBTraceDataMemoryView;
import ghidra.trace.database.listing.DBTraceDefinedDataMemoryView;
import ghidra.trace.database.listing.DBTraceDefinedUnitsMemoryView;
import ghidra.trace.database.listing.DBTraceInstructionsMemoryView;
import ghidra.trace.database.listing.DBTraceUndefinedDataMemoryView;
import ghidra.trace.database.listing.UndefinedDBTraceData;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.database.space.AbstractDBTraceSpaceBasedManager;
import ghidra.trace.database.space.DBTraceDelegatingManager;
import ghidra.trace.database.symbol.DBTraceReferenceManager;
import ghidra.trace.database.thread.DBTraceThread;
import ghidra.trace.database.thread.DBTraceThreadManager;
import ghidra.trace.model.AddressSnap;
import ghidra.trace.model.DefaultAddressSnap;
import ghidra.trace.model.listing.TraceCodeManager;
import ghidra.trace.model.listing.TraceCodeSpace;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceAddressSpace;
import ghidra.util.LockHold;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.DBOpenMode;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class DBTraceCodeManager
extends AbstractDBTraceSpaceBasedManager<DBTraceCodeSpace, DBTraceCodeRegisterSpace>
implements TraceCodeManager,
DBTraceDelegatingManager<DBTraceCodeSpace> {
    public static final String NAME = "Code";
    protected final DBTraceLanguageManager languageManager;
    protected final DBTraceDataTypeManager dataTypeManager;
    protected final DBTraceOverlaySpaceAdapter overlayAdapter;
    protected final DBTraceReferenceManager referenceManager;
    protected final DBCachedObjectStore<DBTraceCodePrototypeEntry> protoStore;
    protected final BiMap<InstructionPrototype, Integer> protoMap = HashBiMap.create();
    protected final DBTraceCodeUnitsMemoryView codeUnits = new DBTraceCodeUnitsMemoryView(this);
    protected final DBTraceInstructionsMemoryView instructions = new DBTraceInstructionsMemoryView(this);
    protected final DBTraceDataMemoryView data = new DBTraceDataMemoryView(this);
    protected final DBTraceDefinedDataMemoryView definedData = new DBTraceDefinedDataMemoryView(this);
    protected final DBTraceUndefinedDataMemoryView undefinedData = new DBTraceUndefinedDataMemoryView(this);
    protected final DBTraceDefinedUnitsMemoryView definedUnits = new DBTraceDefinedUnitsMemoryView(this);
    protected final Map<AddressSnap, UndefinedDBTraceData> undefinedCache = CacheBuilder.newBuilder().removalListener(this::undefinedRemovedFromCache).weakValues().build().asMap();

    protected static Address instructionMax(Instruction instruction, boolean includeDelays) throws AddressOverflowException {
        Address min = instruction.getMinAddress();
        Address max = instruction.getMaxAddress();
        InstructionPrototype prototype = instruction.getPrototype();
        if (includeDelays && prototype.hasDelaySlots()) {
            max = min.addNoWrap((long)(prototype.getFallThroughOffset(instruction.getInstructionContext()) - 1));
        }
        return max;
    }

    public DBTraceCodeManager(DBHandle dbh, DBOpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, Language baseLanguage, DBTrace trace, DBTraceThreadManager threadManager, DBTraceLanguageManager languageManager, DBTraceDataTypeManager dataTypeManager, DBTraceOverlaySpaceAdapter overlayAdapter, DBTraceReferenceManager referenceManager) throws IOException, VersionException {
        super(NAME, dbh, openMode, lock, monitor, baseLanguage, trace, threadManager);
        this.languageManager = languageManager;
        this.dataTypeManager = dataTypeManager;
        this.overlayAdapter = overlayAdapter;
        this.referenceManager = referenceManager;
        DBCachedObjectStoreFactory factory = trace.getStoreFactory();
        this.protoStore = factory.getOrCreateCachedStore("Prototypes", DBTraceCodePrototypeEntry.class, (s, r) -> new DBTraceCodePrototypeEntry(this, s, r), true);
        this.loadPrototypes();
        this.loadSpaces();
    }

    private void undefinedRemovedFromCache(RemovalNotification<AddressSnap, UndefinedDBTraceData> rn) {
    }

    public UndefinedDBTraceData doCreateUndefinedUnit(long snap, Address address, DBTraceThread thread, int frameLevel) {
        return this.undefinedCache.computeIfAbsent(new DefaultAddressSnap(address, snap), ot -> new UndefinedDBTraceData(this.trace, snap, address, thread, frameLevel));
    }

    protected void loadPrototypes() {
        for (DBTraceCodePrototypeEntry protoEnt : this.protoStore.asMap().values()) {
            this.protoMap.put((Object)protoEnt.parsePrototype(), (Object)((int)protoEnt.getKey()));
        }
    }

    protected byte[] valueBytes(RegisterValue rv) {
        byte[] bytes = rv.toBytes();
        return Arrays.copyOfRange(bytes, bytes.length / 2, bytes.length);
    }

    protected int doRecordPrototype(InstructionPrototype prototype, MemBuffer memBuffer, ProcessorContextView context) {
        RegisterValue value;
        DBTraceCodePrototypeEntry protoEnt = (DBTraceCodePrototypeEntry)this.protoStore.create();
        byte[] bytes = new byte[prototype.getLength()];
        if (memBuffer.getBytes(bytes, 0) != bytes.length) {
            throw new AssertionError((Object)"Insufficient bytes for prototype");
        }
        Register baseCtxReg = context.getBaseContextRegister();
        byte[] ctx = baseCtxReg == null ? null : ((value = context.getRegisterValue(baseCtxReg)) == null ? null : this.valueBytes(value));
        protoEnt.set(this.languageManager.getKeyForLanguage(prototype.getLanguage()), bytes, ctx, memBuffer.getAddress(), prototype.isInDelaySlot());
        return (int)protoEnt.getKey();
    }

    protected int findOrRecordPrototype(InstructionPrototype prototype, MemBuffer memBuffer, ProcessorContextView context) {
        return (Integer)this.protoMap.computeIfAbsent((Object)prototype, p -> this.doRecordPrototype(prototype, memBuffer, context));
    }

    protected InstructionPrototype getPrototypeByKey(int key) {
        return (InstructionPrototype)this.protoMap.inverse().get((Object)key);
    }

    @Override
    protected DBTraceCodeSpace createSpace(AddressSpace space, AbstractDBTraceSpaceBasedManager.DBTraceSpaceEntry ent) throws VersionException, IOException {
        return new DBTraceCodeSpace(this, this.dbh, space, ent);
    }

    @Override
    protected DBTraceCodeRegisterSpace createRegisterSpace(AddressSpace space, DBTraceThread thread, AbstractDBTraceSpaceBasedManager.DBTraceSpaceEntry ent) throws VersionException, IOException {
        return new DBTraceCodeRegisterSpace(this, this.dbh, space, ent, thread);
    }

    @Override
    public DBTraceCodeSpace getForSpace(AddressSpace space, boolean createIfAbsent) {
        return (DBTraceCodeSpace)super.getForSpace(space, createIfAbsent);
    }

    @Override
    public Lock readLock() {
        return this.spaceStore.readLock();
    }

    @Override
    public Lock writeLock() {
        return this.spaceStore.writeLock();
    }

    @Override
    public TraceCodeSpace getCodeSpace(TraceAddressSpace space, boolean createIfAbsent) {
        return (TraceCodeSpace)this.get(space, createIfAbsent);
    }

    @Override
    public DBTraceCodeSpace getCodeSpace(AddressSpace space, boolean createIfAbsent) {
        return this.getForSpace(space, createIfAbsent);
    }

    @Override
    public DBTraceCodeRegisterSpace getCodeRegisterSpace(TraceThread thread, boolean createIfAbsent) {
        return (DBTraceCodeRegisterSpace)this.getForRegisterSpace(thread, 0, createIfAbsent);
    }

    @Override
    public DBTraceCodeRegisterSpace getCodeRegisterSpace(TraceThread thread, int frameLevel, boolean createIfAbsent) {
        return (DBTraceCodeRegisterSpace)this.getForRegisterSpace(thread, frameLevel, createIfAbsent);
    }

    @Override
    public DBTraceCodeRegisterSpace getCodeRegisterSpace(TraceStackFrame frame, boolean createIfAbsent) {
        return (DBTraceCodeRegisterSpace)this.getForRegisterSpace(frame, createIfAbsent);
    }

    public void replaceDataTypes(long oldID, long newID) {
        Unfinished.TODO();
    }

    public void clearData(LinkedList<Long> deletedDataTypeIds, TaskMonitor monitor) {
        Unfinished.TODO();
    }

    public void clearLanguage(Range<Long> span, AddressRange range, int langKey, TaskMonitor monitor) throws CancelledException {
        this.delegateDeleteV(range.getAddressSpace(), m -> m.clearLanguage(span, range, langKey, monitor));
    }

    public void deleteLanguage(int langKey, TaskMonitor monitor) throws CancelledException {
        for (DBTraceCodeSpace codeSpace : this.memSpaces.values()) {
            codeSpace.clearLanguage((Range<Long>)Range.all(), codeSpace.all, langKey, monitor);
        }
        for (DBTraceCodeSpace codeSpace : this.regSpaces.values()) {
            codeSpace.clearLanguage((Range<Long>)Range.all(), ((DBTraceCodeRegisterSpace)codeSpace).all, langKey, monitor);
        }
        monitor.setMessage("Clearing instruction prototypes");
        monitor.setMaximum((long)this.protoStore.getRecordCount());
        Iterator it = this.protoStore.asMap().values().iterator();
        while (it.hasNext()) {
            monitor.checkCanceled();
            monitor.incrementProgress(1L);
            DBTraceCodePrototypeEntry protoEnt = (DBTraceCodePrototypeEntry)it.next();
            if (langKey != protoEnt.langKey) continue;
            it.remove();
            this.protoMap.inverse().remove((Object)((int)protoEnt.getKey()));
        }
    }

    @Override
    public void invalidateCache(boolean all) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            this.protoStore.invalidateCache();
            this.protoMap.clear();
            this.loadPrototypes();
            super.invalidateCache(all);
        }
    }

    @Override
    public DBTraceCodeUnitsMemoryView codeUnits() {
        return this.codeUnits;
    }

    @Override
    public DBTraceInstructionsMemoryView instructions() {
        return this.instructions;
    }

    @Override
    public DBTraceDataMemoryView data() {
        return this.data;
    }

    @Override
    public DBTraceDefinedDataMemoryView definedData() {
        return this.definedData;
    }

    @Override
    public DBTraceUndefinedDataMemoryView undefinedData() {
        return this.undefinedData;
    }

    @Override
    public DBTraceDefinedUnitsMemoryView definedUnits() {
        return this.definedUnits;
    }

    @Override
    public AddressSetView getCodeAdded(long from, long to) {
        AddressSet result = new AddressSet();
        if (from == to) {
            return result;
        }
        ArrayList changes = new ArrayList();
        for (DBTraceCodeSpace space : this.memSpaces.values()) {
            changes.addAll(space.dataMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.added(from, to, space.space)).values());
            changes.addAll(space.instructionMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.added(from, to, space.space)).values());
        }
        for (AbstractDBTraceCodeUnit unit : changes) {
            result.add(unit.getRange());
        }
        return result;
    }

    @Override
    public AddressSetView getCodeRemoved(long from, long to) {
        AddressSet result = new AddressSet();
        if (from == to) {
            return result;
        }
        ArrayList changes = new ArrayList();
        for (DBTraceCodeSpace space : this.memSpaces.values()) {
            changes.addAll(space.dataMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.removed(from, to, space.space)).values());
            changes.addAll(space.instructionMapSpace.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.removed(from, to, space.space)).values());
        }
        for (AbstractDBTraceCodeUnit unit : changes) {
            result.add(unit.getRange());
        }
        return result;
    }

    static class ProtoProcessorContext
    implements ProcessorContext {
        private final RegisterValue baseContextValue;
        private final Register baseContextRegister;

        public ProtoProcessorContext(RegisterValue baseContextValue) {
            this.baseContextValue = baseContextValue;
            this.baseContextRegister = baseContextValue == null ? null : baseContextValue.getRegister();
        }

        public Register getBaseContextRegister() {
            return this.baseContextRegister;
        }

        public List<Register> getRegisters() {
            if (this.baseContextRegister == null) {
                return List.of();
            }
            return List.of(this.baseContextRegister);
        }

        public Register getRegister(String name) {
            if (this.baseContextRegister == null || !this.baseContextRegister.getName().equals(name)) {
                return null;
            }
            return this.baseContextRegister;
        }

        public BigInteger getValue(Register register, boolean signed) {
            if (register == null || register != this.baseContextRegister) {
                return null;
            }
            return signed ? this.baseContextValue.getSignedValueIgnoreMask() : this.baseContextValue.getUnsignedValueIgnoreMask();
        }

        public RegisterValue getRegisterValue(Register register) {
            if (register == null || register != this.baseContextRegister) {
                return null;
            }
            return this.baseContextValue;
        }

        public boolean hasValue(Register register) {
            return register != null && register == this.baseContextRegister;
        }

        public void setValue(Register register, BigInteger value) throws ContextChangeException {
            throw new UnsupportedOperationException();
        }

        public void setRegisterValue(RegisterValue value) throws ContextChangeException {
            throw new UnsupportedOperationException();
        }

        public void clearRegister(Register register) throws ContextChangeException {
            throw new UnsupportedOperationException();
        }
    }

    @DBAnnotatedObjectInfo(version=0)
    public static class DBTraceCodePrototypeEntry
    extends DBAnnotatedObject
    implements DBTraceOverlaySpaceAdapter.DecodesAddresses {
        public static final String TABLE_NAME = "Prototypes";
        static final String LANGUAGE_COLUMN_NAME = "Language";
        static final String BYTES_COLUMN_NAME = "Bytes";
        static final String CONTEXT_COLUMN_NAME = "Context";
        static final String ADDRESS_COLUMN_NAME = "Address";
        static final String DELAY_COLUMN_NAME = "Delay";
        @DBAnnotatedColumn(value="Language")
        static DBObjectColumn LANGUAGE_COLUMN;
        @DBAnnotatedColumn(value="Bytes")
        static DBObjectColumn BYTES_COLUMN;
        @DBAnnotatedColumn(value="Context")
        static DBObjectColumn CONTEXT_COLUMN;
        @DBAnnotatedColumn(value="Address")
        static DBObjectColumn ADDRESS_COLUMN;
        @DBAnnotatedColumn(value="Delay")
        static DBObjectColumn DELAY_COLUMN;
        @DBAnnotatedField(column="Language")
        private int langKey;
        @DBAnnotatedField(column="Bytes")
        private byte[] bytes;
        @DBAnnotatedField(column="Context")
        private byte[] context;
        @DBAnnotatedField(column="Address", codec=DBTraceOverlaySpaceAdapter.AddressDBFieldCodec.class)
        private Address address;
        @DBAnnotatedField(column="Delay")
        private boolean delaySlot;
        private DBTraceCodeManager manager;

        public DBTraceCodePrototypeEntry(DBTraceCodeManager manager, DBCachedObjectStore<?> store, DBRecord record) {
            super(store, record);
            this.manager = manager;
        }

        @Override
        public DBTraceOverlaySpaceAdapter getOverlaySpaceAdapter() {
            return this.manager.overlayAdapter;
        }

        void set(int langKey, byte[] bytes, byte[] context, Address address, boolean delaySlot) {
            this.langKey = langKey;
            this.bytes = bytes;
            this.context = context;
            this.address = address;
            this.delaySlot = delaySlot;
            this.update(new DBObjectColumn[]{LANGUAGE_COLUMN, BYTES_COLUMN, CONTEXT_COLUMN, ADDRESS_COLUMN, DELAY_COLUMN});
        }

        int getLanguageKey() {
            return this.langKey;
        }

        InstructionPrototype parsePrototype() {
            Language language = this.manager.languageManager.getLanguageByKey(this.langKey);
            ByteMemBufferImpl memBuffer = new ByteMemBufferImpl(this.address, this.bytes, language.isBigEndian());
            ProtoProcessorContext ctx = new ProtoProcessorContext(DBTraceCodePrototypeEntry.getBaseContextValue(language, this.context, this.address));
            try {
                return language.parse((MemBuffer)memBuffer, (ProcessorContext)ctx, this.delaySlot);
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)("Bad Instruction Prototype found in DB! Address: " + this.address + "Bytes: " + NumericUtilities.convertBytesToString((byte[])this.bytes)));
                return new InvalidPrototype(language);
            }
        }

        static RegisterValue getBaseContextValue(Language language, byte[] context, Address address) {
            Register register = language.getContextBaseRegister();
            if (register == Register.NO_CONTEXT) {
                return null;
            }
            if (context == null) {
                ProgramContextImpl defaultContext = new ProgramContextImpl(language);
                language.applyContextSettings((DefaultProgramContext)defaultContext);
                return defaultContext.getDisassemblyContext(address);
            }
            return new RegisterValue(register, new BigInteger(context));
        }
    }
}

