/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.listing;

import com.google.common.collect.Range;
import db.DBRecord;
import ghidra.program.model.address.Address;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.listing.DBTraceCodeSpace;
import ghidra.trace.database.listing.DBTraceCodeUnitAdapter;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.database.memory.DBTraceMemorySpace;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceAddressSpace;
import ghidra.util.LockHold;
import ghidra.util.database.DBCachedObjectStore;
import java.nio.ByteBuffer;

public abstract class AbstractDBTraceCodeUnit<T extends AbstractDBTraceCodeUnit<T>>
extends DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData<T>
implements DBTraceCodeUnitAdapter {
    protected final DBTraceCodeSpace space;
    protected ByteBuffer byteCache;

    public AbstractDBTraceCodeUnit(DBTraceCodeSpace space, DBTraceAddressSnapRangePropertyMapTree<T, ?> tree, DBCachedObjectStore<?> store, DBRecord record) {
        super(tree, store, record);
        this.space = space;
    }

    @Override
    public TraceAddressSpace getTraceSpace() {
        return this.space;
    }

    public Address getAddress() {
        return this.getX1();
    }

    public Address getMaxAddress() {
        return this.getX2();
    }

    public int getLength() {
        return (int)this.range.getLength();
    }

    @Override
    public TraceThread getThread() {
        return this.space.getThread();
    }

    @Override
    public DBTrace getTrace() {
        return this.space.trace;
    }

    @Override
    public long getStartSnap() {
        return this.getY1();
    }

    @Override
    public void setEndSnap(long endSnap) {
        this.doSetLifespan(DBTraceUtils.toRange(DBTraceUtils.lowerEndpoint((Range<Long>)this.lifespan), endSnap));
    }

    @Override
    public long getEndSnap() {
        return this.getY2();
    }

    @Override
    public int getBytes(ByteBuffer buffer, int addressOffset) {
        try (LockHold hold = this.space.trace.lockRead();){
            int end;
            Address address = this.getX1();
            if (this.byteCache == null) {
                this.byteCache = ByteBuffer.allocate(this.getLength());
            }
            if ((end = addressOffset + buffer.remaining()) > this.byteCache.position()) {
                this.byteCache.limit(Math.min(this.byteCache.capacity(), end));
                DBTraceMemorySpace mem = (DBTraceMemorySpace)this.space.trace.getMemoryManager().get(this.space, false);
                mem.getViewBytes(this.getStartSnap(), address.add((long)this.byteCache.position()), this.byteCache);
            }
            int toCopyFromCache = Math.max(0, Math.min(this.byteCache.position() - addressOffset, buffer.remaining()));
            buffer.put(this.byteCache.array(), addressOffset, toCopyFromCache);
            if (this.byteCache.position() >= end) {
                int n = toCopyFromCache;
                return n;
            }
            assert (this.byteCache.position() == this.byteCache.capacity());
            int startRemains = Math.max(addressOffset, this.byteCache.position());
            DBTraceMemorySpace mem = (DBTraceMemorySpace)this.space.trace.getMemoryManager().get(this.space, false);
            int n = toCopyFromCache + mem.getViewBytes(this.getStartSnap(), address.add((long)startRemains), buffer);
            return n;
        }
    }
}

