/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.gadp.client;

import com.google.common.cache.RemovalNotification;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.ProtocolStringList;
import ghidra.async.AsyncDebouncer;
import ghidra.async.AsyncFence;
import ghidra.async.AsyncPairingCache;
import ghidra.async.AsyncReference;
import ghidra.async.AsyncTimer;
import ghidra.async.AsyncUtils;
import ghidra.async.TypeSpec;
import ghidra.async.loop.AsyncLoopHandlerForFirst;
import ghidra.dbg.DebuggerModelClosedReason;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.AbstractTargetObject;
import ghidra.dbg.agent.SpiTargetObject;
import ghidra.dbg.error.DebuggerIllegalArgumentException;
import ghidra.dbg.error.DebuggerMemoryAccessException;
import ghidra.dbg.error.DebuggerModelAccessException;
import ghidra.dbg.error.DebuggerModelNoSuchPathException;
import ghidra.dbg.error.DebuggerModelTerminatingException;
import ghidra.dbg.error.DebuggerModelTypeException;
import ghidra.dbg.error.DebuggerRegisterAccessException;
import ghidra.dbg.error.DebuggerUserException;
import ghidra.dbg.gadp.GadpVersion;
import ghidra.dbg.gadp.client.DelegateGadpClientTargetObject;
import ghidra.dbg.gadp.client.GadpClientTargetObject;
import ghidra.dbg.gadp.error.GadpErrorException;
import ghidra.dbg.gadp.error.GadpIllegalStateException;
import ghidra.dbg.gadp.error.GadpMessageException;
import ghidra.dbg.gadp.protocol.Gadp;
import ghidra.dbg.gadp.util.AsyncProtobufMessageChannel;
import ghidra.dbg.gadp.util.ProtobufOneofByTypeHelper;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.XmlSchemaContext;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.DefaultAddressFactory;
import ghidra.program.model.address.GenericAddressSpace;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.TriConsumer;
import ghidra.util.exception.DuplicateNameException;
import java.io.EOFException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetConnectedException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jdom.JDOMException;
import utilities.util.ProxyUtilities;

public class GadpClient
extends AbstractDebuggerObjectModel
implements AbstractTargetObject.ProxyFactory<List<Class<? extends TargetObject>>> {
    protected static final int WARN_OUTSTANDING_REQUESTS = 10000;
    protected static final int MAX_OUTSTANDING_REQUESTS = Integer.MAX_VALUE;
    protected static final int REQUEST_TIMEOUT_MILLIS = Integer.MAX_VALUE;
    protected static final ProtobufOneofByTypeHelper<Gadp.RootMessage, Gadp.RootMessage.Builder> MSG_HELPER = ProtobufOneofByTypeHelper.create(Gadp.RootMessage.getDefaultInstance(), Gadp.RootMessage.newBuilder(), "msg");
    protected final String description;
    protected final AsynchronousByteChannel byteChannel;
    protected final AsyncProtobufMessageChannel<Gadp.RootMessage, Gadp.RootMessage> messageChannel;
    protected AsyncReference<ChannelState, DebuggerModelClosedReason> channelState = new AsyncReference((Object)ChannelState.INACTIVE);
    protected GadpVersion activeVersion = null;
    protected XmlSchemaContext schemaContext;
    protected TargetObjectSchema rootSchema;
    protected final TriConsumer<ChannelState, ChannelState, DebuggerModelClosedReason> listenerForChannelState = this::channelStateChanged;
    protected final MessagePairingCache messageMatcher = new MessagePairingCache();
    protected final AtomicInteger sequencer = new AtomicInteger();
    protected final Map<List<String>, GadpClientTargetObject> modelProxies = new HashMap<List<String>, GadpClientTargetObject>();
    protected final GadpAddressFactory factory = new GadpAddressFactory();

    protected static Gadp.RootMessage checkError(Gadp.RootMessage msg) {
        Gadp.ErrorReply error = MSG_HELPER.expect(msg, Gadp.ErrorReply.getDefaultInstance());
        if (error != null) {
            switch (error.getCode()) {
                case EC_NO_INTERFACE: {
                    throw new DebuggerModelTypeException(error.getMessage());
                }
                case EC_NO_OBJECT: {
                    throw new DebuggerModelNoSuchPathException(error.getMessage());
                }
                case EC_BAD_ARGUMENT: {
                    throw new DebuggerIllegalArgumentException(error.getMessage());
                }
                case EC_MEMORY_ACCESS: {
                    throw new DebuggerMemoryAccessException(error.getMessage());
                }
                case EC_REGISTER_ACCESS: {
                    throw new DebuggerRegisterAccessException(error.getMessage());
                }
                case EC_BAD_ADDRESS: {
                    throw new AssertionError((Object)("Client implementation sent an invalid address: " + error.getMessage()));
                }
                case EC_BAD_REQUEST: {
                    throw new AssertionError((Object)("Client implementation sent an invalid request: " + error.getMessage()));
                }
                case UNRECOGNIZED: {
                    throw new AssertionError((Object)("Server replied with an error code unknown to the client: " + error.getCodeValue() + ": " + error.getMessage()));
                }
                case EC_USER_ERROR: {
                    throw new DebuggerUserException(error.getMessage());
                }
                case EC_MODEL_ACCESS: {
                    throw new DebuggerModelAccessException(error.getMessage());
                }
                case EC_UNKNOWN: {
                    throw new RuntimeException("Unknown: " + error.getMessage());
                }
            }
            throw new GadpErrorException(error.getCode(), error.getMessage());
        }
        return msg;
    }

    protected static <T> T nullForNotExist(Throwable e) {
        if ((e = AsyncUtils.unwrapThrowable((Throwable)e)) instanceof DebuggerModelNoSuchPathException) {
            return null;
        }
        return (T)ExceptionUtils.rethrow((Throwable)e);
    }

    protected static GadpClientTargetObject targetObjectOrNull(Object value) {
        if (value instanceof GadpClientTargetObject) {
            return (GadpClientTargetObject)value;
        }
        return null;
    }

    public GadpClient(String description, AsynchronousByteChannel channel) {
        this.channelState.addChangeListener(this.listenerForChannelState);
        this.description = description;
        this.byteChannel = channel;
        this.messageChannel = this.createMessageChannel(channel);
    }

    public SpiTargetObject createProxy(AbstractTargetObject<?> delegate, List<Class<? extends TargetObject>> mixins) {
        return (SpiTargetObject)ProxyUtilities.composeOnDelegate(GadpClientTargetObject.class, (Object)((GadpClientTargetObject)delegate), mixins, (MethodHandles.Lookup)GadpClientTargetObject.LOOKUP);
    }

    protected AsyncProtobufMessageChannel<Gadp.RootMessage, Gadp.RootMessage> createMessageChannel(AsynchronousByteChannel channel) {
        return new AsyncProtobufMessageChannel<Gadp.RootMessage, Gadp.RootMessage>(channel);
    }

    public String toString() {
        return "<GADP Client: " + this.description + " (" + this.channelState.get() + ")>";
    }

    protected void channelStateChanged(ChannelState old, ChannelState set, DebuggerModelClosedReason reason) {
        if (old == ChannelState.NEGOTIATING && set == ChannelState.ACTIVE) {
            ((DebuggerModelListener)this.listeners.fire).modelOpened();
        } else if (old == ChannelState.ACTIVE && set == ChannelState.CLOSED) {
            ((DebuggerModelListener)this.listeners.fire).modelClosed(reason);
            this.root.invalidateSubtree((TargetObject)this.root, "GADP Client disconnected");
            this.messageMatcher.flush((Throwable)new DebuggerModelTerminatingException("GADP Client disconnected"));
        }
    }

    protected CompletableFuture<Gadp.RootMessage> sendCommand(Message.Builder req) {
        Gadp.RootMessage.Builder root = Gadp.RootMessage.newBuilder();
        MSG_HELPER.set(root, req);
        int seqno = this.sequencer.getAndIncrement();
        root.setSequence(seqno);
        Gadp.RootMessage built = root.build();
        CompletableFuture<Gadp.RootMessage> waitOn = this.messageMatcher.waitOn(seqno, k -> new RequestMemo(built));
        if (this.messageMatcher.getUnpairedPromises().size() > 10000) {
            Msg.warn((Object)((Object)this), (Object)"Unanswered request count exceeds 10000! Chances are something's gone wrong.");
        }
        this.checkOpen();
        return this.messageChannel.write(built).thenCompose(__ -> {
            this.checkOpen();
            return waitOn;
        });
    }

    protected <M extends Message> M require(M example, Gadp.RootMessage msg) {
        M inner = MSG_HELPER.expect(msg, example);
        if (inner == null) {
            throw new GadpMessageException("Reply " + msg + " does not contain expected field " + MSG_HELPER.getFieldForTypeOf((MessageOrBuilder)example));
        }
        return inner;
    }

    protected <M extends Message> CompletableFuture<M> sendChecked(Message.Builder req, M exampleRep) {
        if (((ChannelState)((Object)this.channelState.get())).isTerminate()) {
            return CompletableFuture.failedFuture((Throwable)new DebuggerModelTerminatingException("GADP Client disconnected"));
        }
        return this.sendCommand(req).thenApply(msg -> this.require(exampleRep, GadpClient.checkError(msg)));
    }

    protected void receiveLoop() {
        AsyncUtils.loop((TypeSpec)TypeSpec.VOID, loop -> {
            if (((ChannelState)((Object)((Object)this.channelState.get()))).isTerminate()) {
                loop.exit();
                return;
            }
            this.messageChannel.read(Gadp.RootMessage::parseFrom).handle((arg_0, arg_1) -> ((AsyncLoopHandlerForFirst)loop).consume(arg_0, arg_1));
        }, (TypeSpec)TypeSpec.cls(Gadp.RootMessage.class), (msg, loop) -> {
            CompletableFuture.runAsync(() -> {
                Gadp.EventNotification notify = MSG_HELPER.expect((Gadp.RootMessage)msg, Gadp.EventNotification.getDefaultInstance());
                if (notify != null) {
                    this.processNotification(notify);
                } else {
                    this.messageMatcher.fulfill(msg.getSequence(), msg);
                }
            }, this.clientExecutor).exceptionally(ex -> {
                Msg.error((Object)((Object)this), (Object)"Error processing message: ", (Throwable)ex);
                return null;
            });
            loop.repeat();
        }).exceptionally(exc -> {
            if ((exc = AsyncUtils.unwrapThrowable((Throwable)exc)) instanceof NotYetConnectedException) {
                throw new AssertionError("Connect first, please", (Throwable)exc);
            }
            if (exc instanceof EOFException) {
                Msg.error((Object)((Object)this), (Object)"Channel has no data remaining");
            } else if (exc instanceof ClosedChannelException) {
                Msg.error((Object)((Object)this), (Object)"Channel is already closed");
            } else if (exc instanceof CancelledKeyException) {
                Msg.error((Object)((Object)this), (Object)"Channel key is cancelled. Probably closed");
            } else if (exc instanceof RejectedExecutionException) {
                Msg.trace((Object)((Object)this), (Object)"Ignoring rejection", (Throwable)exc);
            } else {
                Msg.error((Object)((Object)this), (Object)"Receive failed for an unknown reason", (Throwable)exc);
            }
            this.channelState.set((Object)ChannelState.CLOSED, (Object)DebuggerModelClosedReason.abnormal((Throwable)exc));
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processNotification(Gadp.EventNotification notify) {
        if (!this.byteChannel.isOpen()) {
            return;
        }
        ProtocolStringList path = notify.getPath().getEList();
        if (notify.hasObjectCreatedEvent()) {
            notify.getObjectCreatedEvent();
            this.createProxy((List<String>)path, notify.getObjectCreatedEvent());
            return;
        }
        if (notify.hasRootAddedEvent()) {
            if (!path.isEmpty()) {
                Msg.warn((Object)((Object)this), (Object)("Server gave non-root path for root-added event: " + PathUtils.toString((List)path)));
            }
            Object object = this.lock;
            synchronized (object) {
                this.addModelRoot(this.getProxy(List.of(), true));
            }
            return;
        }
        GadpClientTargetObject obj = this.getProxy((List<String>)path, true);
        if (obj == null) {
            return;
        }
        obj.getDelegate().handleEvent(notify);
    }

    public String getBrief() {
        return "GADP@" + Integer.toHexString(System.identityHashCode((Object)this)) + " " + this.description;
    }

    public CompletableFuture<Void> connect() {
        Gadp.ConnectRequest.Builder req = GadpVersion.makeRequest();
        if (this.channelState.get() != ChannelState.INACTIVE) {
            throw new GadpIllegalStateException("Client has already connected or started connecting");
        }
        Msg.trace((Object)((Object)this), (Object)"Connecting");
        this.channelState.set((Object)ChannelState.NEGOTIATING, null);
        AsyncFence fence = new AsyncFence();
        fence.include((CompletableFuture)this.sendCommand((Message.Builder)req).thenAccept(msg -> {
            Gadp.ConnectReply rep = this.require(Gadp.ConnectReply.getDefaultInstance(), GadpClient.checkError(msg));
            GadpVersion version = GadpVersion.getByName(rep.getVersion());
            GadpClient gadpClient = this;
            synchronized (gadpClient) {
                this.activeVersion = version;
                try {
                    this.schemaContext = XmlSchemaContext.deserialize((String)rep.getSchemaContext());
                }
                catch (JDOMException e) {
                    throw new GadpMessageException("Invalid schema context XML", e);
                }
                this.rootSchema = this.schemaContext.getSchema(this.schemaContext.name(rep.getRootSchema()));
            }
            this.channelState.set((Object)ChannelState.ACTIVE, null);
            this.receiveLoop();
        }));
        fence.include((CompletableFuture)this.messageChannel.read(Gadp.RootMessage::parseFrom).thenAccept(msg -> this.messageMatcher.fulfill(msg.getSequence(), msg)));
        return fence.ready();
    }

    public CompletableFuture<Void> close() {
        try {
            this.messageChannel.close();
            this.channelState.set((Object)ChannelState.CLOSED, (Object)DebuggerModelClosedReason.normal());
            return super.close();
        }
        catch (RejectedExecutionException e) {
            this.reportError((Object)this, "Client already closed", e);
            return AsyncUtils.NIL;
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    protected void checkOpen() {
        if (!((ChannelState)((Object)this.channelState.get())).isOpen()) {
            throw new GadpIllegalStateException("Channel is not open");
        }
    }

    public boolean isAlive() {
        return this.channelState.get() == ChannelState.ACTIVE;
    }

    public TargetObjectSchema getRootSchema() {
        return this.rootSchema;
    }

    public CompletableFuture<Void> ping(String content) {
        Gadp.PingRequest.Builder req = Gadp.PingRequest.newBuilder().setContent(content);
        return this.sendChecked((Message.Builder)req, Gadp.PingReply.getDefaultInstance()).thenAccept(rep -> {
            if (!content.equals(rep.getContent())) {
                throw new GadpMessageException("Data in ping was corrupt: req=" + req + ",rep=" + rep);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GadpClientTargetObject getProxy(List<String> path, boolean internal) {
        Object object = this.lock;
        synchronized (object) {
            GadpClientTargetObject proxy = this.modelProxies.get(path);
            if (proxy == null && internal) {
                Msg.error((Object)((Object)this), (Object)("Server referred to non-existent object at path: " + PathUtils.toString(path)));
            }
            return proxy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GadpClientTargetObject createProxy(List<String> path, Gadp.ObjectCreatedEvent evt) {
        Object object = this.lock;
        synchronized (object) {
            GadpClientTargetObject parent;
            if (this.modelProxies.containsKey(path)) {
                Msg.error((Object)((Object)this), (Object)("Agent announced creation of an already-existing object: " + PathUtils.toString(path)));
                return this.modelProxies.get(path);
            }
            List parentPath = PathUtils.parent(path);
            if (parentPath == null) {
                parent = null;
            } else {
                parent = this.getProxy(parentPath, true);
                if (parent == null) {
                    Msg.error((Object)((Object)this), (Object)("Got object's created event before its parent's: " + PathUtils.toString(path)));
                }
            }
            GadpClientTargetObject proxy = DelegateGadpClientTargetObject.makeModelProxy(this, parent, PathUtils.getKey(path), evt.getTypeHint(), (List<String>)evt.getInterfaceList());
            this.modelProxies.put(path, proxy);
            return proxy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeProxy(List<String> path, String reason) {
        Object object = this.lock;
        synchronized (object) {
            this.modelProxies.remove(path);
        }
    }

    public AddressFactory getAddressFactory() {
        return this.factory;
    }

    public TargetObject getModelObject(List<String> path) {
        return this.getProxy(path, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAllLocalCaches() {
        List<GadpClientTargetObject> copy;
        Iterator<GadpClientTargetObject> iterator = this.lock;
        synchronized (iterator) {
            copy = List.copyOf(this.modelProxies.values());
        }
        for (GadpClientTargetObject proxy : copy) {
            proxy.getDelegate().doClearCaches();
        }
    }

    protected class MessagePairingCache
    extends AsyncPairingCache<Integer, Gadp.RootMessage> {
        protected final AsyncDebouncer<Void> cacheMonitor;

        public MessagePairingCache() {
            super(4, Integer.MAX_VALUE, Integer.MAX_VALUE);
            this.cacheMonitor = new AsyncDebouncer(AsyncTimer.DEFAULT_TIMER, 500L);
            this.cacheMonitor.addListener(this::cacheSettled);
        }

        protected void resultRemoved(RemovalNotification<Integer, Gadp.RootMessage> rn) {
            Msg.error((Object)((Object)this), (Object)("Received message with unexpected sequence number: " + rn));
        }

        public CompletableFuture<Gadp.RootMessage> waitOn(Integer key, Function<Integer, CompletableFuture<Gadp.RootMessage>> futureFactory) {
            this.cacheMonitor.contact(null);
            return super.waitOn((Object)key, futureFactory);
        }

        protected void promiseRemoved(RemovalNotification<Integer, CompletableFuture<Gadp.RootMessage>> rn) {
            if (rn.wasEvicted()) {
                String message = "Command with sequence number " + rn.getKey() + " evicted because " + rn.getCause();
                Msg.error((Object)((Object)this), (Object)message);
                AsyncUtils.FRAMEWORK_EXECUTOR.execute(() -> ((CompletableFuture)rn.getValue()).completeExceptionally(new TimeoutException(message)));
            }
            this.cacheMonitor.contact(null);
        }

        private void cacheSettled(Void __) {
            int size = this.getUnpairedPromises().size();
            if (size == 0) {
                Msg.info((Object)((Object)this), (Object)"Unanswered request cache size has settled to 0. All is well.");
            } else {
                Msg.info((Object)((Object)this), (Object)("Unanswered request cache size has settled to " + size + ". Chances are something's gone wrong."));
            }
        }
    }

    protected static class GadpAddressFactory
    extends DefaultAddressFactory {
        protected GadpAddressFactory() {
            super(new AddressSpace[]{new GenericAddressSpace("ram", 64, 1, 0)});
        }

        public synchronized AddressSpace getAddressSpace(String name) {
            AddressSpace space = super.getAddressSpace(name);
            if (space != null) {
                return space;
            }
            space = new GenericAddressSpace(name, 64, 1, this.getNumAddressSpaces(), true);
            try {
                this.addAddressSpace(space);
            }
            catch (DuplicateNameException e) {
                throw new AssertionError((Object)e);
            }
            return space;
        }
    }

    protected static class RequestMemo
    extends CompletableFuture<Gadp.RootMessage> {
        private static final boolean RECORD_REQUESTS = !SystemUtilities.isInReleaseMode();
        private final Gadp.RootMessage request;

        public RequestMemo(Gadp.RootMessage request) {
            this.request = RECORD_REQUESTS ? request : null;
        }
    }

    protected static enum ChannelState {
        INACTIVE{

            @Override
            public boolean isOpen() {
                return false;
            }

            @Override
            public boolean isTerminate() {
                return false;
            }
        }
        ,
        NEGOTIATING{

            @Override
            public boolean isOpen() {
                return true;
            }

            @Override
            public boolean isTerminate() {
                return false;
            }
        }
        ,
        ACTIVE{

            @Override
            public boolean isOpen() {
                return true;
            }

            @Override
            public boolean isTerminate() {
                return false;
            }
        }
        ,
        CLOSED{

            @Override
            public boolean isOpen() {
                return false;
            }

            @Override
            public boolean isTerminate() {
                return true;
            }
        };


        public abstract boolean isOpen();

        public abstract boolean isTerminate();
    }
}

