/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.partitioning;

import java.io.PrintStream;
import java.util.ArrayList;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.partitioning.APMPartition;
import org.catacombae.hfsexplorer.partitioning.Partition;
import org.catacombae.hfsexplorer.partitioning.PartitionSystem;
import org.catacombae.io.ReadableByteArrayStream;
import org.catacombae.io.ReadableRandomAccessStream;

public class ApplePartitionMap
implements PartitionSystem {
    private final APMPartition[] partitions;

    public ApplePartitionMap(ReadableRandomAccessStream isoRaf, long pmOffset, int blockSize) {
        isoRaf.seek(pmOffset);
        byte[] currentBlock = new byte[blockSize];
        ArrayList<APMPartition> partitionList = new ArrayList<APMPartition>();
        Short pmSig = null;
        Short pmSigPad = null;
        Long pmMapBlkCnt = null;
        while (partitionList.size() == 0 && pmMapBlkCnt == null || partitionList.size() > 0 && (long)partitionList.size() < pmMapBlkCnt) {
            isoRaf.readFully(currentBlock);
            APMPartition p = new APMPartition(currentBlock, 0, blockSize);
            if (p.isValid()) {
                short curPmSig = p.getPmSig();
                short curPmSigPad = p.getPmSigPad();
                long curPmMapBlkCnt = Util.unsign(p.getPmMapBlkCnt());
                if (pmMapBlkCnt != null && pmSigPad != null && pmSig != null) {
                    if (curPmSig != pmSig || curPmSigPad != pmSigPad || curPmMapBlkCnt != pmMapBlkCnt) {
                        throw new RuntimeException("Redundant fields mismatch at index: " + partitionList.size() + " (curPmSig=" + curPmSig + " pmSig=" + pmSig + " curPmSigPad=" + curPmSigPad + " pmSigPad=" + pmSigPad + " curPmMapBlkCnt=" + curPmMapBlkCnt + " pmMapBlkCnt=" + pmMapBlkCnt + ")");
                    }
                } else {
                    pmSig = curPmSig;
                    pmSigPad = curPmSigPad;
                    pmMapBlkCnt = curPmMapBlkCnt;
                }
                partitionList.add(p);
                continue;
            }
            System.err.println("Erroneous partition:");
            p.printFields(System.err, "  ");
            throw new RuntimeException("Encountered invalid partition map entry at index: " + partitionList.size() + " pmMapBlkCnt=" + pmMapBlkCnt);
        }
        this.partitions = partitionList.toArray(new APMPartition[partitionList.size()]);
    }

    public ApplePartitionMap(byte[] data, int off, int blockSize) {
        this(new ReadableByteArrayStream(data, 0, data.length), (long)off, blockSize);
    }

    public boolean isValid() {
        if (this.partitions.length > 0) {
            for (APMPartition p : this.partitions) {
                if (p.isValid()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int getPartitionCount() {
        return this.partitions.length;
    }

    public int getUsedPartitionCount() {
        return this.getPartitionCount();
    }

    public APMPartition getAPMPartition(int index) {
        return this.partitions[index];
    }

    public APMPartition[] getPartitionEntries() {
        APMPartition[] copy = new APMPartition[this.partitions.length];
        for (int i = 0; i < this.partitions.length; ++i) {
            copy[i] = this.partitions[i];
        }
        return copy;
    }

    public Partition[] getUsedPartitionEntries() {
        return this.getPartitionEntries();
    }

    public byte[] getData() {
        byte[] result = new byte[this.partitions.length * APMPartition.structSize()];
        int offset = 0;
        for (APMPartition ap : this.partitions) {
            byte[] tmp = ap.getData();
            System.arraycopy(tmp, 0, result, offset, tmp.length);
            offset += tmp.length;
        }
        if (offset != result.length) {
            throw new RuntimeException("Internal miscalculation...");
        }
        return result;
    }

    public void printFields(PrintStream ps, String prefix) {
        for (int i = 0; i < this.partitions.length; ++i) {
            ps.println(prefix + " partitions[" + i + "]:");
            this.partitions[i].print(ps, prefix + "  ");
        }
    }

    public void print(PrintStream ps, String prefix) {
        ps.println("Apple Partition Map:");
        this.printFields(ps, prefix);
    }

    public Partition getPartitionEntry(int index) {
        return this.getAPMPartition(index);
    }

    public String getLongName() {
        return "Apple Partition Map";
    }

    public String getShortName() {
        return "APM";
    }
}

