/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer;

import java.awt.Desktop;
import java.awt.Image;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Java6Specific {
    public static boolean canOpen() {
        return Desktop.getDesktop().isSupported(Desktop.Action.OPEN);
    }

    public static void openFile(File f) throws IOException {
        Desktop.getDesktop().open(f);
    }

    public static void setIconImages(ImageIcon[] icons, Window window) {
        LinkedList<Image> iconImages = new LinkedList<Image>();
        for (ImageIcon ii : icons) {
            iconImages.addLast(ii.getImage());
        }
        window.setIconImages(iconImages);
    }

    public static void addRowSorter(JTable table, DefaultTableModel tableModel, int defaultSortColumn, List<Comparator<?>> columnComparators) {
        TableRowSorter<DefaultTableModel> sorter = new TableRowSorter<DefaultTableModel>(tableModel);
        int i = 0;
        for (Comparator<?> c : columnComparators) {
            if (c != null) {
                sorter.setComparator(i, c);
            }
            ++i;
        }
        sorter.toggleSortOrder(defaultSortColumn);
        table.setRowSorter(sorter);
    }
}

