/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.edge;

import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractVisualEdge<V extends VisualVertex>
implements VisualEdge<V> {
    private V start;
    private V end;
    private boolean inHoveredPath = false;
    private boolean inFocusedPath = false;
    private double alpha = 1.0;
    private boolean selected;
    private double emphasis;
    private List<Point2D> articulations = new ArrayList<Point2D>();

    public AbstractVisualEdge(V start, V end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public V getStart() {
        return this.start;
    }

    @Override
    public V getEnd() {
        return this.end;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public boolean isInHoveredVertexPath() {
        return this.inHoveredPath;
    }

    @Override
    public boolean isInFocusedVertexPath() {
        return this.inFocusedPath;
    }

    @Override
    public void setInHoveredVertexPath(boolean inPath) {
        this.inHoveredPath = inPath;
    }

    @Override
    public void setInFocusedVertexPath(boolean inPath) {
        this.inFocusedPath = inPath;
    }

    @Override
    public List<Point2D> getArticulationPoints() {
        return Collections.unmodifiableList(this.articulations);
    }

    @Override
    public void setArticulationPoints(List<Point2D> points) {
        this.articulations = new ArrayList<Point2D>(points);
    }

    @Override
    public void setEmphasis(double emphasisLevel) {
        this.emphasis = emphasisLevel;
    }

    @Override
    public double getEmphasis() {
        return this.emphasis;
    }

    @Override
    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    public String toString() {
        return "[" + this.start + ", " + this.end + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.end == null ? 0 : this.end.hashCode());
        result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractVisualEdge other = (AbstractVisualEdge)obj;
        if (this.end == null ? other.end != null : !this.end.equals(other.end)) {
            return false;
        }
        return !(this.start == null ? other.start != null : !this.start.equals(other.start));
    }
}

