/*
 * Decompiled with CFR 0.152.
 */
package ghidra.python;

import ghidra.framework.Application;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import utilities.util.FileUtilities;

public class PythonUtils {
    public static final String PYTHON_NAME = "jython-2.7.2";
    public static final String PYTHON_CACHEDIR = "jython_cachedir";
    public static final String PYTHON_SRC = "python-src";

    public static File setupPythonHomeDir() throws IOException {
        File pythonModuleDir = Application.getMyModuleRootDirectory().getFile(false);
        File pythonHomeDir = Application.getModuleDataSubDirectory((String)pythonModuleDir.getName(), (String)PYTHON_NAME).getFile(false);
        if (!pythonHomeDir.exists()) {
            throw new IOException("Failed to find the python home directory at: " + pythonHomeDir);
        }
        System.setProperty("python.home", pythonHomeDir.getAbsolutePath());
        return pythonHomeDir;
    }

    public static File setupPythonCacheDir(TaskMonitor monitor) throws CancelledException, IOException {
        File devDir = new File(Application.getUserSettingsDirectory(), "dev");
        File cacheDir = new File(devDir, PYTHON_CACHEDIR);
        if (!FileUtilities.mkdirs((File)cacheDir)) {
            throw new IOException("Failed to create the python cache directory at: " + cacheDir);
        }
        File pythonSrcDestDir = new File(cacheDir, PYTHON_SRC);
        if (!FileUtilities.createDir((File)pythonSrcDestDir)) {
            throw new IOException("Failed to create the python-src directory at: " + pythonSrcDestDir);
        }
        File pythonModuleDir = Application.getMyModuleRootDirectory().getFile(false);
        File pythonSrcDir = new File(pythonModuleDir, PYTHON_SRC);
        if (!pythonSrcDir.exists()) {
            try {
                pythonSrcDir = Application.getModuleDataSubDirectory((String)pythonModuleDir.getName(), (String)PYTHON_SRC).getFile(false);
            }
            catch (FileNotFoundException e) {
                throw new IOException("Failed to find the module's python-src directory");
            }
        }
        try {
            FileUtilities.copyDir((File)pythonSrcDir, (File)pythonSrcDestDir, f -> f.getName().endsWith(".py"), (TaskMonitor)monitor);
        }
        catch (IOException e) {
            throw new IOException("Failed to copy python-src files to: " + pythonSrcDestDir);
        }
        System.setProperty("python.cachedir.skip", "false");
        System.setProperty("python.cachedir", cacheDir.getAbsolutePath());
        System.setProperty("python.path", pythonSrcDestDir.getAbsolutePath());
        return cacheDir;
    }
}

