/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.xml;

import ghidra.util.xml.Counter;
import ghidra.util.xml.XmlAttributes;
import ghidra.util.xml.XmlUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import resources.ResourceManager;

public class XmlWriter {
    private PrintWriter writer;
    private int indentLevel;
    private boolean incompleteLine;
    private boolean addedText;
    private Counter counter;

    public XmlWriter(File file, String dtdName) throws IOException {
        this(new FileOutputStream(file), dtdName);
    }

    public XmlWriter(OutputStream out, String dtdName) throws IOException {
        this.writer = new PrintWriter(out);
        this.counter = new Counter();
        if (dtdName != null) {
            this.writeDTD(dtdName);
        }
    }

    public Counter getCounter() {
        return this.counter;
    }

    public void close() {
        this.writer.close();
    }

    public void writeDTD(String dtdName) throws IOException {
        String line;
        InputStream is = ResourceManager.getResourceAsStream(dtdName);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while ((line = reader.readLine()) != null) {
            this.writer.println(line);
        }
        reader.close();
    }

    public void startElement(String name) {
        this.startElement(name, null, null);
    }

    public void startElement(String name, XmlAttributes attrs) {
        this.startElement(name, attrs, null);
    }

    private void startElement(String name, XmlAttributes attrs, String text) {
        if (this.addedText) {
            throw new IllegalStateException("Cannot have child elements in parent elements with text!");
        }
        this.counter.increment(name);
        if (this.incompleteLine) {
            this.writer.println(">");
            this.incompleteLine = false;
        }
        this.indent();
        ++this.indentLevel;
        this.writer.print("<");
        this.writer.print(name);
        this.incompleteLine = true;
        if (attrs != null) {
            this.writer.print(attrs.toString());
        }
        if (text != null) {
            this.writer.print(">");
            this.writer.print(XmlUtilities.escapeElementEntities(text));
            this.incompleteLine = false;
            this.addedText = true;
        }
    }

    public void endElement(String name) {
        --this.indentLevel;
        if (this.incompleteLine) {
            this.writer.println(" />");
        } else {
            if (!this.addedText) {
                this.indent();
            }
            this.writer.println("</" + name + ">");
        }
        this.incompleteLine = false;
        this.addedText = false;
    }

    public void writeElement(String name, XmlAttributes attrs) {
        this.writeElement(name, attrs, null);
    }

    public void writeElement(String name, XmlAttributes attrs, String text) {
        this.startElement(name, attrs, text);
        this.endElement(name);
    }

    private void indent() {
        for (int i = 0; i < this.indentLevel; ++i) {
            this.writer.print("    ");
        }
    }
}

