/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.classfinder;

import ghidra.util.Msg;
import ghidra.util.classfinder.ClassFinder;
import ghidra.util.classfinder.ClassLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class ClassPackage
extends ClassLocation {
    private static final FileFilter CLASS_FILTER = pathname -> pathname.getName().endsWith(".class");
    private Set<ClassPackage> children = new HashSet<ClassPackage>();
    private File rootDir;
    private File packageDir;
    private String packageName;

    ClassPackage(File rootDir, String packageName, TaskMonitor monitor) throws CancelledException {
        monitor.checkCanceled();
        this.rootDir = rootDir;
        this.packageName = packageName;
        this.packageDir = this.getPackageDir(rootDir, packageName);
        this.scanClasses();
        this.scanSubPackages(monitor);
    }

    private void scanClasses() {
        String path = this.rootDir.getAbsolutePath();
        Set<String> allClassNames = this.getAllClassNames();
        for (String className : allClassNames) {
            Class<?> c = ClassFinder.loadExtensionPoint(path, className);
            if (c == null) continue;
            this.classes.add(c);
        }
    }

    private void scanSubPackages(TaskMonitor monitor) throws CancelledException {
        File[] subdirs = this.packageDir.listFiles();
        if (subdirs == null) {
            Msg.debug((Object)this, (Object)("Directory does not exist: " + this.packageDir));
            return;
        }
        for (File subdir : subdirs) {
            Object pkg;
            monitor.checkCanceled();
            if (!subdir.isDirectory() || ((String)(pkg = subdir.getName())).contains(".")) continue;
            if (this.packageName.length() > 0) {
                pkg = this.packageName + "." + (String)pkg;
            }
            monitor.setMessage("Scanning package: " + (String)pkg);
            this.children.add(new ClassPackage(this.rootDir, (String)pkg, monitor));
        }
    }

    private File getPackageDir(File lRootDir, String lPackageName) {
        return new File(lRootDir, lPackageName.replace('.', File.separatorChar));
    }

    @Override
    void getClasses(Set<Class<?>> set, TaskMonitor monitor) throws CancelledException {
        this.checkForDuplicates(set);
        set.addAll(this.classes);
        Iterator<ClassPackage> it = this.children.iterator();
        while (it.hasNext()) {
            monitor.checkCanceled();
            ClassPackage subPkg = it.next();
            subPkg.getClasses(set, monitor);
        }
    }

    private Set<String> getAllClassNames() {
        File[] files = this.packageDir.listFiles(CLASS_FILTER);
        if (files == null) {
            return Collections.emptySet();
        }
        HashSet<String> results = new HashSet<String>(files.length);
        for (File file : files) {
            Object name = file.getName();
            name = ((String)name).substring(0, ((String)name).length() - 6);
            if (this.packageName.length() > 0) {
                name = this.packageName + "." + (String)name;
            }
            results.add((String)name);
        }
        return results;
    }
}

