/*
 * Decompiled with CFR 0.152.
 */
package generic.timer;

import generic.timer.GhidraSwingTimer;
import generic.timer.TimerCallback;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;

public class ExpiringSwingTimer
extends GhidraSwingTimer {
    private long startMs = System.currentTimeMillis();
    private int expireMs;
    private BooleanSupplier isReady;
    private ExpiringTimerCallback expiringTimerCallback = new ExpiringTimerCallback();
    private TimerCallback clientCallback;
    private AtomicBoolean didRun = new AtomicBoolean();

    public static ExpiringSwingTimer runWhen(BooleanSupplier isReady, int expireMs, Runnable runnable) {
        int delay = 250;
        ExpiringSwingTimer timer = new ExpiringSwingTimer(delay, expireMs, isReady, runnable);
        timer.start();
        return timer;
    }

    public ExpiringSwingTimer(int delay, int expireMs, BooleanSupplier isReady, Runnable runnable) {
        super(0, delay, null);
        this.expireMs = expireMs;
        this.isReady = isReady;
        this.clientCallback = () -> runnable.run();
        super.setTimerCallback(this.expiringTimerCallback);
        this.setRepeats(true);
    }

    public boolean didRun() {
        return this.didRun.get();
    }

    @Override
    public void start() {
        if (this.didRun() || this.isExpired()) {
            return;
        }
        super.start();
    }

    public boolean isExpired() {
        long now = System.currentTimeMillis();
        int elapsed = (int)(now - this.startMs);
        return elapsed > this.expireMs;
    }

    @Override
    public void setTimerCallback(TimerCallback callback) {
        this.clientCallback = Objects.requireNonNull(callback);
    }

    private class ExpiringTimerCallback
    implements TimerCallback {
        private ExpiringTimerCallback() {
        }

        @Override
        public void timerFired() {
            if (ExpiringSwingTimer.this.isReady.getAsBoolean()) {
                ExpiringSwingTimer.this.clientCallback.timerFired();
                ExpiringSwingTimer.this.didRun.set(true);
                ExpiringSwingTimer.this.stop();
                return;
            }
            if (ExpiringSwingTimer.this.isExpired()) {
                ExpiringSwingTimer.this.stop();
            }
        }
    }
}

