/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.manager.cmd;

import SWIG.SBThread;
import agent.lldb.lldb.DebugClient;
import agent.lldb.manager.LldbEvent;
import agent.lldb.manager.cmd.AbstractLldbCommand;
import agent.lldb.manager.cmd.LldbPendingCommand;
import agent.lldb.manager.evt.AbstractLldbCompletedCommandEvent;
import agent.lldb.manager.evt.LldbProcessCreatedEvent;
import agent.lldb.manager.impl.LldbManagerImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class LldbLaunchProcessWithOptionsCommand
extends AbstractLldbCommand<SBThread> {
    private LldbProcessCreatedEvent created = null;
    private boolean completed = false;
    private String fileName;
    private List<String> args;
    private List<String> envp;
    private List<String> pathsIO;
    private String wdir;
    private long flags;
    private boolean stopAtEntry;

    public LldbLaunchProcessWithOptionsCommand(LldbManagerImpl manager, Map<String, ?> args) {
        super(manager);
        this.fileName = (String)args.get("File");
        String argstr = (String)args.get("Args");
        this.args = argstr.equals("") ? new ArrayList() : Arrays.asList(argstr.split(" "));
        String envstr = (String)args.get("Env");
        this.envp = envstr.equals("") ? new ArrayList() : Arrays.asList(envstr.split(" "));
        this.pathsIO = new ArrayList<String>();
        this.pathsIO.add((String)args.get("STDIN"));
        this.pathsIO.add((String)args.get("STDOUT"));
        this.pathsIO.add((String)args.get("STDERR"));
        this.wdir = (String)args.get("Dir");
        this.flags = DebugClient.DebugCreateFlags.LAUNCH_DEFAULT.getMask();
        this.stopAtEntry = false;
        if (((Boolean)args.get("Exec")).booleanValue()) {
            this.flags |= DebugClient.DebugCreateFlags.LAUNCH_EXEC.getMask();
        }
        if (((Boolean)args.get("BreakOnLaunch")).booleanValue()) {
            this.flags |= DebugClient.DebugCreateFlags.LAUNCH_DEBUG.getMask();
        }
        if (((Boolean)args.get("BreakOnEntry")).booleanValue()) {
            this.flags |= DebugClient.DebugCreateFlags.LAUNCH_STOP_AT_ENTRY.getMask();
            this.stopAtEntry = true;
        }
        if (((Boolean)args.get("ASLR")).booleanValue()) {
            this.flags |= DebugClient.DebugCreateFlags.LAUNCH_DISABLE_ASLR.getMask();
        }
        if (((Boolean)args.get("STDIO")).booleanValue()) {
            this.flags |= DebugClient.DebugCreateFlags.LAUNCH_DISABLE_STDIO.getMask();
        }
        if (((Boolean)args.get("NewTTY")).booleanValue()) {
            this.flags |= DebugClient.DebugCreateFlags.LAUNCH_IN_TTY.getMask();
        }
        if (((Boolean)args.get("Shell")).booleanValue()) {
            this.flags |= DebugClient.DebugCreateFlags.LAUNCH_IN_SHELL.getMask();
        }
        if (((Boolean)args.get("NewGroup")).booleanValue()) {
            this.flags |= DebugClient.DebugCreateFlags.LAUNCH_IN_SEP_GROUP.getMask();
        }
        if (((Boolean)args.get("ExitRace")).booleanValue()) {
            this.flags |= DebugClient.DebugCreateFlags.LAUNCH_DONT_SET_EXIT_STATUS.getMask();
        }
        if (((Boolean)args.get("Detach")).booleanValue()) {
            this.flags |= DebugClient.DebugCreateFlags.LAUNCH_DETACH_ON_ERROR.getMask();
        }
        if (((Boolean)args.get("ExpandArgs")).booleanValue()) {
            this.flags |= DebugClient.DebugCreateFlags.LAUNCH_SHELL_EXPAND_ARGS.getMask();
        }
        if (((Boolean)args.get("CloseTTY")).booleanValue()) {
            this.flags |= DebugClient.DebugCreateFlags.LAUNCH_CLOSE_TTY_ON_EXIT.getMask();
        }
        if (((Boolean)args.get("Inherit")).booleanValue()) {
            this.flags |= DebugClient.DebugCreateFlags.LAUNCH_INHERIT_FROM_PARENT.getMask();
        }
    }

    @Override
    public boolean handle(LldbEvent<?> evt, LldbPendingCommand<?> pending) {
        if (evt instanceof AbstractLldbCompletedCommandEvent && pending.getCommand().equals(this)) {
            this.completed = true;
        } else if (evt instanceof LldbProcessCreatedEvent) {
            this.created = (LldbProcessCreatedEvent)evt;
        }
        return this.completed && this.created != null;
    }

    @Override
    public SBThread complete(LldbPendingCommand<?> pending) {
        return this.manager.getEventThread();
    }

    @Override
    public void invoke() {
        DebugClient client = this.manager.getClient();
        client.createProcess(client.getLocalServer(), this.fileName, this.args, this.envp, this.pathsIO, this.wdir, this.flags, this.stopAtEntry);
    }
}

