/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.services;

import com.google.common.collect.Range;
import ghidra.app.services.DebuggerStaticMappingChangeListener;
import ghidra.framework.model.DomainFile;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.TraceSnap;
import ghidra.trace.model.modules.TraceConflictedMappingException;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceSection;
import ghidra.trace.model.modules.TraceStaticMappingManager;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.util.MathUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public interface DebuggerStaticMappingService {
    public void addMapping(TraceLocation var1, ProgramLocation var2, long var3, boolean var5) throws TraceConflictedMappingException;

    public void addIdentityMapping(Trace var1, Program var2, Range<Long> var3, boolean var4);

    public void addModuleMapping(TraceModule var1, long var2, Program var4, boolean var5) throws TraceConflictedMappingException;

    public void addModuleMappings(Collection<ModuleMapEntry> var1, TaskMonitor var2, boolean var3) throws CancelledException;

    public void addSectionMappings(Collection<SectionMapEntry> var1, TaskMonitor var2, boolean var3) throws CancelledException;

    public Set<Program> getOpenMappedProgramsAtSnap(Trace var1, long var2);

    public ProgramLocation getOpenMappedLocation(TraceLocation var1);

    public ProgramLocation getStaticLocationFromDynamic(ProgramLocation var1);

    public Set<TraceLocation> getOpenMappedLocations(ProgramLocation var1);

    public TraceLocation getOpenMappedLocation(Trace var1, ProgramLocation var2, long var3);

    public ProgramLocation getDynamicLocationFromStatic(TraceProgramView var1, ProgramLocation var2);

    public Map<Program, Collection<MappedAddressRange>> getOpenMappedViews(Trace var1, AddressSetView var2, long var3);

    public Map<TraceSnap, Collection<MappedAddressRange>> getOpenMappedViews(Program var1, AddressSetView var2);

    public Set<Program> openMappedProgramsInView(Trace var1, AddressSetView var2, long var3, Set<Exception> var5);

    public void addChangeListener(DebuggerStaticMappingChangeListener var1);

    public void removeChangeListener(DebuggerStaticMappingChangeListener var1);

    public Set<DomainFile> findProbableModulePrograms(TraceModule var1);

    public Set<Program> collectLibraries(Program var1, TaskMonitor var2) throws CancelledException;

    public ModuleMapProposal proposeModuleMap(TraceModule var1, Program var2);

    public ModuleMapProposal proposeModuleMap(TraceModule var1, Collection<? extends Program> var2);

    public Map<TraceModule, ModuleMapProposal> proposeModuleMaps(Collection<? extends TraceModule> var1, Collection<? extends Program> var2);

    public SectionMapProposal proposeSectionMap(TraceSection var1, Program var2, MemoryBlock var3);

    public SectionMapProposal proposeSectionMap(TraceModule var1, Program var2);

    public SectionMapProposal proposeSectionMap(TraceModule var1, Collection<? extends Program> var2);

    public Map<TraceModule, SectionMapProposal> proposeSectionMaps(Collection<? extends TraceModule> var1, Collection<? extends Program> var2);

    public static class MappedAddressRange
    implements Comparable<MappedAddressRange> {
        private final AddressRange srcRange;
        private final AddressRange dstRange;
        private final int hashCode;
        private final long shift;

        public MappedAddressRange(AddressRange srcRange, AddressRange dstRange) {
            this.srcRange = srcRange;
            this.dstRange = dstRange;
            this.hashCode = Objects.hash(dstRange, srcRange);
            this.shift = dstRange.getMinAddress().getOffset() - srcRange.getMinAddress().getOffset();
        }

        public String toString() {
            return "<MappedRange " + this.srcRange + "::" + this.dstRange + ">";
        }

        public long getShift() {
            return this.shift;
        }

        public Address mapSourceToDestination(Address saddr) {
            return this.dstRange.getAddressSpace().getAddress(saddr.getOffset() + this.shift);
        }

        public Address mapDestinationToSource(Address daddr) {
            return this.srcRange.getAddressSpace().getAddress(daddr.getOffset() - this.shift);
        }

        public AddressRange mapSourceToDestination(AddressRange srng) {
            try {
                return new AddressRangeImpl(this.mapSourceToDestination(srng.getMinAddress()), srng.getLength());
            }
            catch (AddressOverflowException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public AddressRange mapDestinationToSource(AddressRange drng) {
            try {
                return new AddressRangeImpl(this.mapDestinationToSource(drng.getMinAddress()), drng.getLength());
            }
            catch (AddressOverflowException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public AddressRange getSourceAddressRange() {
            return this.srcRange;
        }

        public AddressRange getDestinationAddressRange() {
            return this.dstRange;
        }

        @Override
        public int compareTo(MappedAddressRange that) {
            int c = this.dstRange.compareTo((Object)that.dstRange);
            if (c != 0) {
                return c;
            }
            c = this.srcRange.compareTo((Object)that.srcRange);
            if (c != 0) {
                return c;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MappedAddressRange)) {
                return false;
            }
            MappedAddressRange that = (MappedAddressRange)obj;
            if (!this.dstRange.equals(that.dstRange)) {
                return false;
            }
            return this.srcRange.equals(that.srcRange);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    public static class SectionMapEntry {
        private final TraceSection section;
        private Program program;
        private MemoryBlock block;

        public SectionMapEntry(TraceSection section, Program program, MemoryBlock block) {
            this.section = section;
            this.program = program;
            this.block = block;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SectionMapEntry)) {
                return false;
            }
            SectionMapEntry that = (SectionMapEntry)obj;
            return this.section == that.section;
        }

        public int hashCode() {
            return Objects.hash(this.section);
        }

        public TraceModule getModule() {
            return this.section.getModule();
        }

        public TraceSection getSection() {
            return this.section;
        }

        public Program getProgram() {
            return this.program;
        }

        public MemoryBlock getBlock() {
            return this.block;
        }

        public void setBlock(Program program, MemoryBlock block) {
            this.program = program;
            this.block = block;
        }

        public long getLength() {
            return MathUtilities.unsignedMin((long)this.section.getRange().getLength(), (long)this.block.getSize());
        }
    }

    public static class ModuleMapEntry {
        private final TraceModule module;
        private Program program;
        private AddressRange moduleRange;

        public static boolean includeBlock(Program program, MemoryBlock block) {
            if (program.getImageBase().getAddressSpace() != block.getStart().getAddressSpace()) {
                return false;
            }
            if (!block.isLoaded()) {
                return false;
            }
            if (block.isMapped()) {
                return false;
            }
            return !"EXTERNAL".equals(block.getName());
        }

        public static long computeImageSize(Program program) {
            Address imageBase = program.getImageBase();
            long imageSize = 0L;
            for (MemoryBlock block : program.getMemory().getBlocks()) {
                if (!ModuleMapEntry.includeBlock(program, block)) continue;
                imageSize = Math.max(imageSize, block.getEnd().subtract(imageBase) + 1L);
            }
            return imageSize;
        }

        public ModuleMapEntry(TraceModule module, Program program, AddressRange moduleRange) {
            this.module = module;
            this.program = program;
            this.moduleRange = moduleRange;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ModuleMapEntry)) {
                return false;
            }
            ModuleMapEntry that = (ModuleMapEntry)obj;
            return this.module == that.module;
        }

        public int hashCode() {
            return Objects.hash(this.module);
        }

        public TraceModule getModule() {
            return this.module;
        }

        public AddressRange getModuleRange() {
            return this.moduleRange;
        }

        public Program getProgram() {
            return this.program;
        }

        public void setProgram(Program program) {
            this.program = program;
            try {
                this.moduleRange = new AddressRangeImpl(this.module.getBase(), ModuleMapEntry.computeImageSize(program));
            }
            catch (AddressOverflowException e) {
                throw new IllegalArgumentException("Specified program is too large for module's memory space");
            }
        }
    }

    public static interface SectionMapProposal {
        public static Collection<SectionMapEntry> flatten(Collection<SectionMapProposal> proposals) {
            LinkedHashSet<SectionMapEntry> result = new LinkedHashSet<SectionMapEntry>();
            for (SectionMapProposal map : proposals) {
                result.addAll(map.computeMap().values());
            }
            return result;
        }

        public static Set<SectionMapEntry> removeOverlapping(Collection<SectionMapEntry> entries) {
            return entries.stream().filter(e -> {
                TraceStaticMappingManager manager = e.section.getTrace().getStaticMappingManager();
                Range moduleLifespan = e.section.getModule().getLifespan();
                return manager.findAllOverlapping(e.section.getRange(), moduleLifespan).isEmpty();
            }).collect(Collectors.toSet());
        }

        public TraceModule getModule();

        public Program getProgram();

        public double computeScore();

        public MemoryBlock getDestination(TraceSection var1);

        public Map<TraceSection, SectionMapEntry> computeMap();
    }

    public static interface ModuleMapProposal {
        public static Collection<ModuleMapEntry> flatten(Collection<ModuleMapProposal> proposals) {
            LinkedHashSet<ModuleMapEntry> result = new LinkedHashSet<ModuleMapEntry>();
            for (ModuleMapProposal map : proposals) {
                result.addAll(map.computeMap().values());
            }
            return result;
        }

        public static Set<ModuleMapEntry> removeOverlapping(Collection<ModuleMapEntry> entries) {
            return entries.stream().filter(e -> {
                TraceStaticMappingManager manager = e.module.getTrace().getStaticMappingManager();
                return manager.findAllOverlapping(e.moduleRange, e.module.getLifespan()).isEmpty();
            }).collect(Collectors.toSet());
        }

        public TraceModule getModule();

        public Program getProgram();

        public double computeScore();

        public Map<TraceModule, ModuleMapEntry> computeMap();
    }
}

