/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import ghidra.app.plugin.core.debug.gui.objects.DebuggerObjectsProvider;
import ghidra.app.plugin.core.debug.gui.objects.ObjectContainer;
import ghidra.app.services.ConsoleService;
import ghidra.async.AsyncFence;
import ghidra.async.AsyncUtils;
import ghidra.async.TypeSpec;
import ghidra.async.seq.AsyncSequenceHandlerForRunner;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.Component;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;

public class DisplayMethodsAction
extends DockingAction {
    private static final String GROUP = null;
    private PluginTool tool;
    protected DebuggerObjectsProvider provider;
    private ConsoleService consoleService;

    public DisplayMethodsAction(PluginTool tool, String owner, DebuggerObjectsProvider provider) {
        super("DisplayMethods", owner);
        this.tool = tool;
        this.provider = provider;
        String[] path = new String[]{"Display methods"};
        this.setPopupMenuData(new MenuData(path, GROUP));
        this.setHelpLocation(new HelpLocation(owner, "display_methods"));
        provider.addLocalAction((DockingActionIf)this);
    }

    public boolean isEnabledForContext(ActionContext context) {
        Object obj = context.getContextObject();
        ObjectContainer sel = this.provider.getSelectedContainer(obj);
        return sel != null;
    }

    public void actionPerformed(ActionContext context) {
        Object contextObject = context.getContextObject();
        ObjectContainer container = this.provider.getSelectedContainer(contextObject);
        if (container != null) {
            this.doAction(container);
        }
    }

    protected void doAction(ObjectContainer container) {
        this.consoleService = this.provider.getConsoleService();
        if (this.consoleService == null) {
            Msg.showError((Object)((Object)this), (Component)this.tool.getToolFrame(), (String)"DisplayMethods Error", (Object)"ConsoleService not found: Please add a console service provider to your tool");
            return;
        }
        ObjectContainer clone = ObjectContainer.clone(container);
        this.getAttributes(clone);
    }

    private CompletableFuture<Void> getAttributes(ObjectContainer container) {
        AtomicReference attributes = new AtomicReference();
        return AsyncUtils.sequence((TypeSpec)TypeSpec.VOID).then(seq -> {
            AsyncFence fence = new AsyncFence();
            TargetObject to = container.getTargetObject();
            fence.include((CompletableFuture)to.fetchAttributes().thenAccept(attributes::set));
            fence.ready().handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForRunner)seq).next(arg_0, arg_1));
        }).then(seq -> {
            this.finishGetAttributes(container, attributes);
            seq.exit();
        }).finish();
    }

    protected void finishGetAttributes(ObjectContainer container, AtomicReference<Map<String, ?>> methods) {
        this.consoleService.println("Methods for " + container.getTargetObject().getName() + ":");
        Map<String, ?> map = methods.get();
        for (String key : map.keySet()) {
            TargetObject to;
            Object object = map.get(key);
            if (!(object instanceof TargetObject) || !((to = (TargetObject)object) instanceof TargetMethod)) continue;
            this.consoleService.println(key);
        }
    }
}

