/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.modules;

import ghidra.framework.model.UndoableDomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.model.DefaultTraceLocation;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceSection;
import ghidra.util.Msg;
import ghidra.util.database.UndoableTransaction;
import ghidra.util.exception.DuplicateNameException;

public class SectionRow {
    private final TraceSection section;

    public SectionRow(TraceSection section) {
        this.section = section;
    }

    public TraceModule getModule() {
        return this.section.getModule();
    }

    public TraceSection getSection() {
        return this.section;
    }

    public void setName(String name) {
        try (UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)this.section.getTrace(), (String)"Renamed section", (boolean)true);){
            this.section.setName(name);
        }
        catch (DuplicateNameException e) {
            Msg.showError((Object)this, null, (String)"Rename Section", (Object)"Section name is already taken by another in the same module");
        }
    }

    public String getName() {
        return this.section.getName();
    }

    public String getModuleName() {
        return this.section.getModule().getName();
    }

    public AddressRange getRange() {
        return this.section.getRange();
    }

    public Address getStart() {
        return this.section.getStart();
    }

    public Address getEnd() {
        return this.section.getEnd();
    }

    public long getLength() {
        return this.section.getRange().getLength();
    }

    public TraceLocation getTraceLocation() {
        return new DefaultTraceLocation(this.section.getModule().getTrace(), null, this.section.getModule().getLifespan(), this.section.getStart());
    }
}

