/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.breakpoint;

import docking.widgets.table.GTableFilterPanel;
import ghidra.app.plugin.core.debug.gui.breakpoint.DebuggerBreakpointEnablementTableCellRenderer;
import ghidra.app.plugin.core.debug.gui.breakpoint.LogicalBreakpointRow;
import ghidra.app.services.LogicalBreakpoint;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.table.TableCellEditor;

public class DebuggerBreakpointEnablementTableCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private final GTableFilterPanel<LogicalBreakpointRow> filterPanel;
    protected final JButton button = new JButton();
    private LogicalBreakpoint.Enablement value = LogicalBreakpoint.Enablement.NONE;
    private LogicalBreakpointRow row;

    public DebuggerBreakpointEnablementTableCellEditor(GTableFilterPanel<LogicalBreakpointRow> filterPanel) {
        this.filterPanel = filterPanel;
        this.button.setHorizontalAlignment(0);
        this.button.setOpaque(true);
        this.button.setBorder(BorderFactory.createEmptyBorder());
        this.button.setUI(new BasicButtonUI());
        this.button.addActionListener(this);
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (isSelected) {
            this.button.setBackground(table.getSelectionBackground());
        } else {
            this.button.setBackground(table.getBackground());
        }
        this.row = (LogicalBreakpointRow)this.filterPanel.getRowObject(row);
        this.value = (LogicalBreakpoint.Enablement)((Object)value);
        this.button.setIcon(DebuggerBreakpointEnablementTableCellRenderer.iconForEnablement(this.value));
        this.button.setHorizontalAlignment(0);
        return this.button;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean mapped = this.row.isMapped();
        this.value = this.value.getToggled(mapped);
        this.fireEditingStopped();
    }
}

