/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.code;

import db.BinaryField;
import db.BooleanField;
import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.code.ProtoDBAdapter;
import ghidra.program.database.code.ProtoDBAdapterV0;
import ghidra.program.database.code.ProtoDBAdapterV1;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.util.DatabaseVersionException;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.InstructionPrototype;
import ghidra.program.model.lang.InvalidPrototype;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.ProcessorContext;
import ghidra.program.model.lang.ProcessorContextView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.mem.ByteMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.MD5Utilities;
import ghidra.util.Msg;
import ghidra.util.datastruct.ObjectArray;
import ghidra.util.datastruct.ObjectIntHashtable;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.NoValueException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.StringTokenizer;

class PrototypeManager {
    private ObjectIntHashtable<InstructionPrototype> protoHt;
    private ObjectArray protoArray;
    private int nextKey;
    private Language language;
    private Table contextTable;
    private ProtoDBAdapter protoAdapter;
    private ProgramDB program;
    private AddressMap addrMap;
    private ProgramContext programContext;
    private Register baseContextRegister;
    static final int BYTES_COL = 0;
    static final int ADDR_COL = 1;
    static final int DELAY_COL = 2;
    static final String PROTO_TABLE_NAME = "Prototypes";
    static final Schema PROTO_SCHEMA = PrototypeManager.createPrototypeSchema();
    static final String CONTEXT_TABLE_NAME = "ContextTable";
    static final Schema REGISTER_SCHEMA = PrototypeManager.createRegisterSchema();
    private static final int CURRENT_VERSION = 1;
    private static final int CURRENT_CONTEXT_VERSION = 1;

    private static Schema createPrototypeSchema() {
        Schema schema = new Schema(1, "Keys", new Field[]{BinaryField.INSTANCE, LongField.INSTANCE, BooleanField.INSTANCE}, new String[]{"Bytes", "Address", "InDelaySlot"});
        return schema;
    }

    private static Schema createRegisterSchema() {
        Schema schema = new Schema(1, "Keys", new Field[]{StringField.INSTANCE}, new String[]{"Register Context"});
        return schema;
    }

    PrototypeManager(DBHandle dbHandle, AddressMap addrMap, int openMode, TaskMonitor monitor) throws VersionException, IOException {
        this.addrMap = addrMap;
        if (openMode == 0) {
            this.createDBTables(dbHandle);
            this.contextTable = dbHandle.createTable(CONTEXT_TABLE_NAME, REGISTER_SCHEMA);
        }
        this.findAdapters(dbHandle, openMode);
        this.loadContextTable(dbHandle, openMode);
        if (openMode == 3) {
            this.upgradeTable(dbHandle, monitor);
        }
    }

    private void upgradeTable(DBHandle dbHandle, TaskMonitor monitor) throws IOException {
        if (this.protoAdapter.getVersion() != 1) {
            this.upgradeProtoTable(dbHandle, monitor);
        }
        if (this.contextTable.getSchema().getVersion() != 1) {
            this.upgradeContextTable(dbHandle, monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeContextTable(DBHandle dbHandle, TaskMonitor monitor) throws IOException {
        monitor.setMessage("Upgrading Table: ContextTable");
        DBHandle temp = dbHandle.getScratchPad();
        try {
            DBRecord rec;
            Table tempTable = temp.createTable(CONTEXT_TABLE_NAME, REGISTER_SCHEMA);
            int count = 0;
            monitor.initialize((long)(this.protoAdapter.getNumRecords() * 2));
            RecordIterator it = this.contextTable.iterator();
            while (it.hasNext()) {
                monitor.setProgress((long)(++count));
                if (monitor.isCancelled()) {
                    throw new IOException("Upgrade Cancelled");
                }
                rec = it.next();
                String oldValue = rec.getString(0);
                rec.setString(0, this.convertString(oldValue));
                tempTable.putRecord(rec);
            }
            dbHandle.deleteTable(CONTEXT_TABLE_NAME);
            this.contextTable = dbHandle.createTable(CONTEXT_TABLE_NAME, REGISTER_SCHEMA);
            it = tempTable.iterator();
            while (it.hasNext()) {
                monitor.setProgress((long)(++count));
                if (monitor.isCancelled()) {
                    throw new IOException("Upgrade Cancelled");
                }
                rec = it.next();
                this.contextTable.putRecord(rec);
            }
        }
        finally {
            temp.deleteTable(CONTEXT_TABLE_NAME);
        }
    }

    private String convertString(String oldValue) {
        StringTokenizer tok = new StringTokenizer(oldValue, ",");
        int n = tok.countTokens();
        byte[] values = new byte[4 * n];
        int i = 0;
        while (tok.hasMoreTokens()) {
            String next = tok.nextToken();
            int value = Integer.parseInt(next);
            this.putInt(values, i, value);
            i += 4;
        }
        BigInteger newValue = new BigInteger(values);
        return newValue.toString();
    }

    private void putInt(byte[] bytes, int index, int value) {
        for (int i = 3; i >= 0; --i) {
            bytes[index + i] = (byte)value;
            value >>= 8;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeProtoTable(DBHandle dbHandle, TaskMonitor monitor) throws IOException {
        monitor.setMessage("Upgrading Table: Prototypes");
        DBHandle temp = dbHandle.getScratchPad();
        try {
            this.createDBTables(temp);
            ProtoDBAdapterV1 tempAdapter = new ProtoDBAdapterV1(temp);
            int count = 0;
            monitor.initialize((long)(this.protoAdapter.getNumRecords() * 2));
            RecordIterator it = this.protoAdapter.getRecords();
            while (it.hasNext()) {
                monitor.setProgress((long)(++count));
                if (monitor.isCancelled()) {
                    throw new IOException("Upgrade Cancelled");
                }
                DBRecord rec = it.next();
                tempAdapter.createRecord((int)rec.getKey(), rec.getLongValue(1), rec.getBinaryData(0), rec.getBooleanValue(2));
            }
            Table t = dbHandle.getTable(PROTO_TABLE_NAME);
            t.deleteAll();
            dbHandle.deleteTable(PROTO_TABLE_NAME);
            dbHandle.createTable(PROTO_TABLE_NAME, PROTO_SCHEMA);
            this.protoAdapter = new ProtoDBAdapterV1(dbHandle);
            it = tempAdapter.getRecords();
            while (it.hasNext()) {
                monitor.setProgress((long)(++count));
                if (monitor.isCancelled()) {
                    throw new IOException("Upgrade Cancelled");
                }
                DBRecord rec = it.next();
                this.protoAdapter.createRecord((int)rec.getKey(), rec.getLongValue(1), rec.getBinaryData(0), rec.getBooleanValue(2));
            }
        }
        catch (DatabaseVersionException e) {
            Msg.showError((Object)this, null, (String)"Unbelievable Error", (Object)"can't happen", (Throwable)e);
        }
        finally {
            temp.deleteTable(PROTO_TABLE_NAME);
        }
    }

    void setLanguage(Language lang) throws IOException {
        this.contextTable.deleteAll();
        this.protoAdapter.deleteAll();
        this.language = lang;
        this.init();
    }

    private void init() {
        this.protoHt = new ObjectIntHashtable();
        this.protoArray = new ObjectArray();
        this.programContext = this.program.getProgramContext();
        this.baseContextRegister = this.programContext.getBaseContextRegister();
        this.populatePrototypes();
    }

    void setProgram(ProgramDB program) {
        this.program = program;
        this.language = program.getLanguage();
        this.init();
    }

    int getID(InstructionPrototype prototype, MemBuffer memBuf, ProcessorContextView context) {
        try {
            return this.protoHt.get((Object)prototype);
        }
        catch (NoValueException noValueException) {
            try {
                int protoID = (int)this.protoAdapter.getKey();
                this.nextKey = protoID + 1;
                int protoArrayIndex = protoID;
                this.protoArray.put(protoArrayIndex, (Object)prototype);
                this.protoHt.put((Object)prototype, protoID);
                byte[] b = new byte[prototype.getLength()];
                if (memBuf.getBytes(b, 0) != b.length) {
                    throw new AssertException("Insufficient bytes for prototype");
                }
                Address address = memBuf.getAddress();
                long addr = this.addrMap.getKey(address, true);
                this.protoAdapter.createRecord(protoID, addr, b, prototype.isInDelaySlot());
                if (this.baseContextRegister != null) {
                    RegisterValue registerValue = context.getRegisterValue(this.baseContextRegister);
                    String valueStr = registerValue != null ? registerValue.getUnsignedValueIgnoreMask().toString() : "0";
                    DBRecord record = REGISTER_SCHEMA.createRecord((long)protoID);
                    record.setString(0, valueStr);
                    this.contextTable.putRecord(record);
                }
                return protoID;
            }
            catch (IOException exc) {
                this.program.dbError(exc);
                return 0;
            }
        }
    }

    InstructionPrototype getPrototype(int protoID) {
        if (protoID < 0) {
            return null;
        }
        return (InstructionPrototype)this.protoArray.get(protoID);
    }

    private void populatePrototypes() {
        try {
            RecordIterator iter = this.protoAdapter.getRecords();
            while (iter.hasNext()) {
                DBRecord record = iter.next();
                int protoID = (int)record.getKey();
                if (this.protoArray.get(protoID) != null) continue;
                InstructionPrototype proto = this.createPrototype(protoID, record);
                this.protoArray.put(protoID, (Object)proto);
                this.protoHt.put((Object)proto, protoID);
            }
            this.nextKey = (int)this.protoAdapter.getKey();
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
    }

    void clearCache() {
        try {
            if (this.nextKey != (int)this.protoAdapter.getKey()) {
                this.protoArray = new ObjectArray(this.protoAdapter.getNumRecords());
                this.protoHt.removeAll();
                this.populatePrototypes();
            }
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
    }

    int getOriginalPrototypeLength(int protoId) {
        try {
            DBRecord record = this.protoAdapter.getRecord(protoId);
            if (record != null) {
                byte[] bytes = record.getBinaryData(0);
                return bytes.length;
            }
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        return 0;
    }

    RegisterValue getOriginalPrototypeContext(InstructionPrototype prototype, Register baseContextReg) throws NoValueException {
        try {
            DBRecord record = this.contextTable.getRecord((long)this.protoHt.get((Object)prototype));
            if (record != null) {
                String s = record.getString(0);
                BigInteger value = s != null ? new BigInteger(s) : BigInteger.ZERO;
                return new RegisterValue(baseContextReg, value);
            }
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        return null;
    }

    private InstructionPrototype createPrototype(long protoID, DBRecord record) {
        Address address = this.addrMap.decodeAddress(record.getLongValue(1));
        byte[] bytes = record.getBinaryData(0);
        ByteMemBufferImpl memBuffer = new ByteMemBufferImpl(address, bytes, this.language.isBigEndian());
        ProtoProcessorContext context = new ProtoProcessorContext(record.getKey(), address);
        try {
            return this.language.parse(memBuffer, context, record.getBooleanValue(2));
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Bad Instruction Prototype found! Address: " + address + ", Bytes: " + String.copyValueOf(MD5Utilities.hexDump((byte[])bytes))));
            return new InvalidPrototype(this.language);
        }
    }

    private void createDBTables(DBHandle handle) throws IOException {
        handle.createTable(PROTO_TABLE_NAME, PROTO_SCHEMA);
    }

    private void findAdapters(DBHandle handle, int openMode) throws VersionException {
        try {
            this.protoAdapter = new ProtoDBAdapterV1(handle);
            return;
        }
        catch (DatabaseVersionException databaseVersionException) {
            this.protoAdapter = this.getOldAdapter(handle);
            if (openMode == 1) {
                throw new VersionException(true);
            }
            return;
        }
    }

    private void loadContextTable(DBHandle dbHandle, int openMode) throws VersionException, IOException {
        this.contextTable = dbHandle.getTable(CONTEXT_TABLE_NAME);
        if (this.contextTable == null) {
            this.contextTable = dbHandle.createTable(CONTEXT_TABLE_NAME, REGISTER_SCHEMA);
        }
        if (openMode == 1 && this.contextTable.getSchema().getVersion() != 1) {
            throw new VersionException(true);
        }
    }

    private ProtoDBAdapter getOldAdapter(DBHandle handle) throws VersionException {
        try {
            return new ProtoDBAdapterV0(handle);
        }
        catch (DatabaseVersionException e) {
            throw new VersionException(false);
        }
    }

    class ProtoProcessorContext
    implements ProcessorContext {
        private long protoID;
        private Address address;

        ProtoProcessorContext(long protoID, Address address) {
            this.protoID = protoID;
            this.address = address;
        }

        @Override
        public Register getRegister(String name) {
            return PrototypeManager.this.programContext.getRegister(name);
        }

        @Override
        public List<Register> getRegisters() {
            return PrototypeManager.this.programContext.getRegisters();
        }

        @Override
        public boolean hasValue(Register register) {
            return false;
        }

        @Override
        public RegisterValue getRegisterValue(Register register) {
            if (register != PrototypeManager.this.baseContextRegister || PrototypeManager.this.baseContextRegister == null) {
                return null;
            }
            try {
                DBRecord record = PrototypeManager.this.contextTable.getRecord(this.protoID);
                if (record != null) {
                    String s = record.getString(0);
                    BigInteger value = s != null ? new BigInteger(s) : BigInteger.ZERO;
                    return new RegisterValue(register, value);
                }
            }
            catch (IOException e) {
                PrototypeManager.this.program.dbError(e);
            }
            return PrototypeManager.this.programContext.getDefaultValue(PrototypeManager.this.baseContextRegister, this.address);
        }

        @Override
        public BigInteger getValue(Register register, boolean signed) {
            if (register != PrototypeManager.this.baseContextRegister || PrototypeManager.this.baseContextRegister == null) {
                return null;
            }
            try {
                DBRecord record = PrototypeManager.this.contextTable.getRecord(this.protoID);
                if (record != null) {
                    String s = record.getString(0);
                    BigInteger value = new BigInteger(s);
                    return value;
                }
            }
            catch (IOException e) {
                PrototypeManager.this.program.dbError(e);
            }
            RegisterValue value = PrototypeManager.this.programContext.getDefaultValue(PrototypeManager.this.baseContextRegister, this.address);
            if (value != null) {
                return signed ? value.getSignedValueIgnoreMask() : value.getUnsignedValueIgnoreMask();
            }
            return null;
        }

        @Override
        public void setValue(Register register, BigInteger value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setRegisterValue(RegisterValue value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clearRegister(Register register) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Register getBaseContextRegister() {
            return PrototypeManager.this.baseContextRegister;
        }
    }
}

