/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.utils;

import java.io.PrintStream;
import java.math.BigInteger;

public class XmlUtils {
    private XmlUtils() {
    }

    public static void a_v(PrintStream s, String attr, String val) {
        s.append(' ').append(attr).append("=\"");
        XmlUtils.xml_escape(s, val);
        s.append("\"");
    }

    public static void a_v_i(PrintStream s, String attr, long val) {
        s.append(' ').append(attr).append("=\"");
        s.append(Long.toString(val, 10)).append("\"");
    }

    public static void a_v_u(PrintStream s, String attr, long val) {
        s.append(' ').append(attr).append("=\"0x");
        s.append(Long.toHexString(val)).append("\"");
    }

    public static void a_v_b(PrintStream s, String attr, boolean val) {
        s.append(' ').append(attr).append("=\"");
        s.append(val ? "true" : "false").append("\"");
    }

    public static boolean decodeBoolean(String boolString) {
        if (boolString == null || boolString.length() == 0) {
            return false;
        }
        char firstc = boolString.charAt(0);
        if (firstc == 't') {
            return true;
        }
        if (firstc == '1') {
            return true;
        }
        return firstc == 'y';
    }

    public static int decodeUnknownInt(String intString) {
        if (intString == null) {
            return 0;
        }
        if ("0".equals(intString)) {
            return 0;
        }
        BigInteger bi = null;
        bi = intString.startsWith("0x") ? new BigInteger(intString.substring(2), 16) : (intString.startsWith("0") ? new BigInteger(intString.substring(1), 8) : new BigInteger(intString, 10));
        return bi.intValue();
    }

    public static long decodeUnknownLong(String longString) {
        if (longString == null) {
            return 0L;
        }
        if ("0".equals(longString)) {
            return 0L;
        }
        BigInteger bi = null;
        bi = longString.startsWith("0x") ? new BigInteger(longString.substring(2), 16) : (longString.startsWith("0") ? new BigInteger(longString.substring(1), 8) : new BigInteger(longString, 10));
        return bi.longValue();
    }

    public static void xml_escape(PrintStream s, String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '<') {
                s.append("&lt;");
                continue;
            }
            if (c == '>') {
                s.append("&gt;");
                continue;
            }
            if (c == '\"') {
                s.append("&quot;");
                continue;
            }
            if (c == '\'') {
                s.append("&apos;");
                continue;
            }
            if (c == '&') {
                s.append("&amp;");
                continue;
            }
            s.append(c);
        }
    }
}

