/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.pattern;

import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.SleighDebugLogger;
import ghidra.app.plugin.processors.sleigh.pattern.CombinePattern;
import ghidra.app.plugin.processors.sleigh.pattern.ContextPattern;
import ghidra.app.plugin.processors.sleigh.pattern.DisjointPattern;
import ghidra.app.plugin.processors.sleigh.pattern.OrPattern;
import ghidra.app.plugin.processors.sleigh.pattern.Pattern;
import ghidra.app.plugin.processors.sleigh.pattern.PatternBlock;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.StringUtilities;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

public class InstructionPattern
extends DisjointPattern {
    private PatternBlock maskvalue;

    @Override
    public PatternBlock getBlock(boolean context) {
        return context ? null : this.maskvalue;
    }

    public InstructionPattern() {
        this.maskvalue = null;
    }

    public InstructionPattern(PatternBlock mv) {
        this.maskvalue = mv;
    }

    public InstructionPattern(boolean tf) {
        this.maskvalue = new PatternBlock(tf);
    }

    public PatternBlock getBlock() {
        return this.maskvalue;
    }

    @Override
    public Pattern simplifyClone() {
        return new InstructionPattern((PatternBlock)this.maskvalue.clone());
    }

    @Override
    public void shiftInstruction(int sa) {
        this.maskvalue.shift(sa);
    }

    @Override
    public Pattern doOr(Pattern b, int sa) {
        if (b.numDisjoint() > 0) {
            return b.doOr(this, -sa);
        }
        if (b instanceof CombinePattern) {
            return b.doOr(this, -sa);
        }
        DisjointPattern res1 = (DisjointPattern)this.simplifyClone();
        DisjointPattern res2 = (DisjointPattern)b.simplifyClone();
        if (sa < 0) {
            res1.shiftInstruction(-sa);
        } else {
            res2.shiftInstruction(sa);
        }
        return new OrPattern(res1, res2);
    }

    @Override
    public Pattern doAnd(Pattern b, int sa) {
        PatternBlock respattern;
        if (b.numDisjoint() > 0) {
            return b.doAnd(this, -sa);
        }
        if (b instanceof CombinePattern) {
            return b.doAnd(this, -sa);
        }
        if (b instanceof ContextPattern) {
            InstructionPattern newpat = (InstructionPattern)this.simplifyClone();
            if (sa < 0) {
                newpat.shiftInstruction(-sa);
            }
            return new CombinePattern((ContextPattern)b.simplifyClone(), newpat);
        }
        if (sa < 0) {
            PatternBlock a = (PatternBlock)this.maskvalue.clone();
            a.shift(-sa);
            respattern = a.andBlock(((InstructionPattern)b).maskvalue);
        } else {
            PatternBlock c = (PatternBlock)((InstructionPattern)b).maskvalue.clone();
            c.shift(sa);
            respattern = this.maskvalue.andBlock(c);
        }
        return new InstructionPattern(respattern);
    }

    @Override
    public boolean isMatch(ParserWalker walker, SleighDebugLogger debug) throws MemoryAccessException {
        boolean match = this.maskvalue.isInstructionMatch(walker);
        this.debugPatternMatch(debug, walker, match);
        return match;
    }

    private void debugPatternMatch(SleighDebugLogger debug, ParserWalker walker, boolean match) {
        if (debug == null) {
            return;
        }
        debug.append("byte pattern: ");
        if (this.alwaysTrue()) {
            debug.append("always-Matched\n");
        } else if (this.alwaysFalse()) {
            debug.append("always-Failed\n");
        } else {
            MemBuffer memBuf = walker.getParserContext().getMemBuffer();
            int offset = walker.getOffset(-1) + this.maskvalue.offset;
            int byteCnt = this.maskvalue.maskvec.length * 4;
            byte[] bytes = new byte[byteCnt];
            memBuf.getBytes(bytes, offset);
            if (match) {
                debug.addInstructionPattern(offset, this.maskvalue);
            }
            if (debug.isVerboseEnabled()) {
                debug.append("mask=");
                debug.append(this.maskvalue.maskvec, -1, 0);
                debug.append("\n");
                int endoffset = offset + bytes.length - 1;
                String leader = "bytes[" + offset + "-" + endoffset + "]=";
                debug.append(StringUtilities.pad((String)leader, (char)' ', (int)19));
                debug.append(bytes, -1, 0);
                debug.append("\n");
                debug.append("       match-value=");
                debug.append(this.maskvalue.valvec, -1, 0);
                debug.append(" " + (match ? "Matched" : "Failed") + "\n");
            }
        }
    }

    @Override
    public boolean alwaysTrue() {
        return this.maskvalue.alwaysTrue();
    }

    @Override
    public boolean alwaysFalse() {
        return this.maskvalue.alwaysFalse();
    }

    @Override
    public boolean alwaysInstructionTrue() {
        return this.maskvalue.alwaysTrue();
    }

    @Override
    public void restoreXml(XmlPullParser parser) {
        XmlElement el = parser.start(new String[]{"instruct_pat"});
        this.maskvalue = new PatternBlock(true);
        this.maskvalue.restoreXml(parser);
        parser.end(el);
    }

    public String toString() {
        if (this.alwaysTrue()) {
            return "always";
        }
        if (this.alwaysFalse()) {
            return "never";
        }
        return "ins:" + this.maskvalue;
    }
}

