/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.emulator;

import ghidra.app.emulator.memory.EmulatorLoadData;
import ghidra.pcode.memstate.MemoryFaultHandler;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;

public interface EmulatorConfiguration {
    public Language getLanguage();

    public EmulatorLoadData getLoadData();

    public MemoryFaultHandler getMemoryFaultHandler();

    default public boolean isWriteBackEnabled() {
        return false;
    }

    default public int getPreferredMemoryPageSize() {
        return 4096;
    }

    default public String getProgramCounterName() {
        Language lang = this.getLanguage();
        Register pcReg = lang.getProgramCounter();
        if (pcReg == null) {
            throw new IllegalStateException("Language has not defined Program Counter Register: " + lang.getLanguageID());
        }
        return pcReg.getName();
    }
}

