/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.RegisterName;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractSymbolInternals;

public class ProcedureStartMipsSymbolInternals
extends AbstractSymbolInternals {
    protected long parentPointer;
    protected long endPointer;
    protected long nextPointer;
    protected long procedureLength;
    protected long debugStartOffset;
    protected long debugEndOffset;
    protected long integerRegisterSaveMask;
    protected long floatingPointRegisterSaveMask;
    protected long integerRegisterSaveOffset;
    protected long floatingPointRegisterSaveOffset;
    protected RecordNumber typeRecordNumber;
    protected long symbolOffset;
    protected int symbolSegment;
    protected int indexOfRegisterContainingReturnValue;
    protected RegisterName registerContainingReturnValue;
    protected int indexOfRegisterContainingFramePointer;
    protected RegisterName registerContainingFramePointer;
    protected String name;

    public static ProcedureStartMipsSymbolInternals parse(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        ProcedureStartMipsSymbolInternals result = new ProcedureStartMipsSymbolInternals(pdb);
        ProcedureStartMipsSymbolInternals.parseInitialFields(pdb, reader, result);
        result.typeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        result.symbolOffset = reader.parseUnsignedIntVal();
        result.symbolSegment = pdb.parseSegment(reader);
        ProcedureStartMipsSymbolInternals.parseMoreFields(pdb, reader, result);
        result.name = reader.parseString(pdb, StringParseType.StringUtf8Nt);
        return result;
    }

    public static ProcedureStartMipsSymbolInternals parse16(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        ProcedureStartMipsSymbolInternals result = new ProcedureStartMipsSymbolInternals(pdb);
        ProcedureStartMipsSymbolInternals.parseInitialFields(pdb, reader, result);
        result.symbolOffset = reader.parseUnsignedIntVal();
        result.symbolSegment = pdb.parseSegment(reader);
        result.typeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 16);
        ProcedureStartMipsSymbolInternals.parseMoreFields(pdb, reader, result);
        result.name = reader.parseString(pdb, StringParseType.StringUtf8St);
        return result;
    }

    public static ProcedureStartMipsSymbolInternals parseSt(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        ProcedureStartMipsSymbolInternals result = new ProcedureStartMipsSymbolInternals(pdb);
        ProcedureStartMipsSymbolInternals.parseInitialFields(pdb, reader, result);
        result.typeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        result.symbolOffset = reader.parseUnsignedIntVal();
        result.symbolSegment = pdb.parseSegment(reader);
        ProcedureStartMipsSymbolInternals.parseMoreFields(pdb, reader, result);
        result.name = reader.parseString(pdb, StringParseType.StringUtf8St);
        return result;
    }

    private static void parseInitialFields(AbstractPdb pdb, PdbByteReader reader, ProcedureStartMipsSymbolInternals result) throws PdbException {
        result.parentPointer = reader.parseUnsignedIntVal();
        result.endPointer = reader.parseUnsignedIntVal();
        result.nextPointer = reader.parseUnsignedIntVal();
        result.procedureLength = reader.parseUnsignedIntVal();
        result.debugStartOffset = reader.parseUnsignedIntVal();
        result.debugEndOffset = reader.parseUnsignedIntVal();
        result.integerRegisterSaveMask = reader.parseUnsignedIntVal();
        result.floatingPointRegisterSaveMask = reader.parseUnsignedIntVal();
        result.integerRegisterSaveOffset = reader.parseUnsignedIntVal();
        result.floatingPointRegisterSaveOffset = reader.parseUnsignedIntVal();
    }

    private static void parseMoreFields(AbstractPdb pdb, PdbByteReader reader, ProcedureStartMipsSymbolInternals result) throws PdbException {
        result.indexOfRegisterContainingReturnValue = reader.parseUnsignedByteVal();
        result.registerContainingReturnValue = new RegisterName(pdb, result.indexOfRegisterContainingReturnValue);
        result.indexOfRegisterContainingFramePointer = reader.parseUnsignedByteVal();
        result.registerContainingFramePointer = new RegisterName(pdb, result.indexOfRegisterContainingFramePointer);
    }

    public ProcedureStartMipsSymbolInternals(AbstractPdb pdb) {
        super(pdb);
    }

    public long getParentPointer() {
        return this.parentPointer;
    }

    public long getEndPointer() {
        return this.endPointer;
    }

    public long getNextPointer() {
        return this.nextPointer;
    }

    public long getProcedureLength() {
        return this.procedureLength;
    }

    public long getDebugStartOffset() {
        return this.debugStartOffset;
    }

    public long getDebugEndOffset() {
        return this.debugEndOffset;
    }

    public RecordNumber getTypeRecordNumber() {
        return this.typeRecordNumber;
    }

    public long getOffset() {
        return this.symbolOffset;
    }

    public int getSegment() {
        return this.symbolSegment;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void emit(StringBuilder builder) {
        StringBuilder prefixBuilder = new StringBuilder();
        StringBuilder postfixBuilder = new StringBuilder();
        prefixBuilder.append(String.format(": [%04X:%08X], Length: %08X, ", this.symbolSegment, this.symbolOffset, this.procedureLength));
        postfixBuilder.append(String.format(": %s, ", this.pdb.getTypeRecord(this.typeRecordNumber)));
        postfixBuilder.append(String.format("   Parent: %08X, End: %08X, Next: %08X\n", this.parentPointer, this.endPointer, this.nextPointer));
        postfixBuilder.append(String.format("   Debug start: %08X, Debug end: %08X\n", this.debugStartOffset, this.debugEndOffset));
        postfixBuilder.append(String.format("   Reg Save: %08X, FP Save: %08X, Int Offset: %08X, FP Offset: %08X\n", this.integerRegisterSaveMask, this.floatingPointRegisterSaveMask, this.integerRegisterSaveOffset, this.floatingPointRegisterSaveOffset));
        postfixBuilder.append(String.format("   Return Reg: %s, Frame Reg: %s\n", this.registerContainingReturnValue, this.registerContainingFramePointer));
        builder.insert(0, prefixBuilder);
        builder.append((CharSequence)postfixBuilder);
    }
}

