/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.filechooser;

import docking.widgets.DropDownTextFieldDataModel;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.list.GListCellRenderer;
import ghidra.util.DateUtils;
import ghidra.util.HTMLUtilities;
import ghidra.util.exception.AssertException;
import java.awt.Component;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.filechooser.FileSystemView;

public class FileDropDownSelectionDataModel
implements DropDownTextFieldDataModel<File> {
    private static final char END_CHAR = '\uffff';
    private FileSystemView fileSystemView = FileSystemView.getFileSystemView();
    private final GhidraFileChooser chooser;
    private Comparator<File> sortComparator = new FileComparator();
    private Comparator<Object> searchComparator = new FileSearchComparator();

    public FileDropDownSelectionDataModel(GhidraFileChooser chooser) {
        this.chooser = chooser;
    }

    @Override
    public String getDisplayText(File value) {
        return value.getName();
    }

    @Override
    public int getIndexOfFirstMatchingEntry(List<File> data, String text) {
        int lastPreferredMatchIndex = -1;
        int i = 0;
        while (i < data.size()) {
            File file = data.get(i);
            String filename = file.getName();
            if (filename.equals(text)) {
                return i;
            }
            if (!filename.equalsIgnoreCase(text)) {
                return lastPreferredMatchIndex;
            }
            lastPreferredMatchIndex = i++;
        }
        return -1;
    }

    @Override
    public ListCellRenderer<File> getListRenderer() {
        return new FileDropDownRenderer();
    }

    @Override
    public List<File> getMatchingData(String searchText) {
        if (searchText == null || searchText.length() == 0) {
            return Collections.emptyList();
        }
        File directory = this.chooser.getCurrentDirectory();
        File[] files = directory.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        ArrayList<File> list = new ArrayList<File>();
        for (File file : files) {
            list.add(file);
        }
        Collections.sort(list, this.sortComparator);
        return this.getMatchingSubList(searchText, searchText + "\uffff", list);
    }

    private List<File> getMatchingSubList(String searchTextStart, String searchTextEnd, List<File> list) {
        int startIndex = Collections.binarySearch(list, searchTextStart, this.searchComparator);
        int endIndex = Collections.binarySearch(list, searchTextEnd, this.searchComparator);
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        }
        if (endIndex < 0) {
            endIndex = -endIndex - 1;
        }
        return list.subList(startIndex, endIndex);
    }

    @Override
    public String getDescription(File file) {
        boolean isDir = file.isDirectory();
        return "<html><table><tr><td>" + (isDir ? "Directory: " : "File: ") + "</td><td><b>" + HTMLUtilities.escapeHTML((String)file.getName()) + "</b></td></tr><tr><td>Size:</td><td>" + (Serializable)(isDir ? "0" : Long.valueOf(file.length())) + " bytes</td></tr><tr><td>Last modified:</td><td>" + DateUtils.formatDateTimestamp((Date)new Date(file.lastModified())) + "</td></tr></table>";
    }

    private class FileDropDownRenderer
    extends GListCellRenderer<File> {
        private FileDropDownRenderer() {
        }

        @Override
        protected String getItemText(File file) {
            return file.getName();
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends File> list, File file, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, file, index, isSelected, cellHasFocus);
            this.setIcon(FileDropDownSelectionDataModel.this.fileSystemView.getSystemIcon(file));
            this.setVerticalAlignment(1);
            return this;
        }
    }

    private class FileSearchComparator
    implements Comparator<Object> {
        private FileSearchComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof File && o2 instanceof String) {
                File file = (File)o1;
                return file.getName().compareToIgnoreCase((String)o2);
            }
            throw new AssertException("FileCompartor used to compare files against a String key!");
        }
    }

    private class FileComparator
    implements Comparator<File> {
        private FileComparator() {
        }

        @Override
        public int compare(File f1, File f2) {
            return f1.getName().compareToIgnoreCase(f2.getName());
        }
    }
}

