/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ext4;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.ext4.Ext4FileSystem;
import ghidra.file.formats.ext4.Ext4SuperBlock;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryByteProvider;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeByteProvider;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class Ext4FileSystemFactory
implements GFileSystemProbeByteProvider,
GFileSystemFactoryByteProvider<Ext4FileSystem> {
    public Ext4FileSystem create(FSRLRoot targetFSRL, ByteProvider byteProvider, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        Ext4FileSystem fs = new Ext4FileSystem(targetFSRL, byteProvider);
        fs.mountFS(monitor);
        return fs;
    }

    public boolean probe(ByteProvider byteProvider, FileSystemService fsService, TaskMonitor taskMonitor) throws IOException, CancelledException {
        try {
            BinaryReader reader = new BinaryReader(byteProvider, true);
            reader.setPointerIndex(1024);
            Ext4SuperBlock superBlock = new Ext4SuperBlock(reader);
            return superBlock.isValid();
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

