/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.sublayout;

import java.util.function.Supplier;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.TreeLayout;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.sublayout.TreeCollapser;

public class VisualTreeCollapser<V, E>
extends TreeCollapser<V, E> {
    protected VisualizationServer<V, E> vv;

    public VisualTreeCollapser(VisualizationServer<V, E> vv, Supplier<V> vertexSupplier) {
        super(vv.getVisualizationModel().getGraph(), vertexSupplier);
        this.vv = vv;
    }

    @Override
    public V collapse(V root) {
        V collapsedVertex = super.collapse(root);
        if (collapsedVertex != null) {
            LayoutModel<V> layoutModel = this.vv.getVisualizationModel().getLayoutModel();
            layoutModel.set(collapsedVertex, (Point)layoutModel.apply(root));
            LayoutAlgorithm<V> layoutAlgorithm = this.vv.getVisualizationModel().getLayoutAlgorithm();
            if (layoutAlgorithm instanceof TreeLayout) {
                ((TreeLayout)layoutAlgorithm).setRootPredicate(null);
            }
            this.vv.getVisualizationModel().setGraph(this.tree, true);
            this.vv.repaint();
        }
        return root;
    }

    @Override
    public void expand(V clusterRoot) {
        super.expand(clusterRoot);
        LayoutModel<V> layoutModel = this.vv.getVisualizationModel().getLayoutModel();
        layoutModel.set(clusterRoot, (Point)layoutModel.apply(clusterRoot));
        LayoutAlgorithm<V> layoutAlgorithm = this.vv.getVisualizationModel().getLayoutAlgorithm();
        if (layoutAlgorithm instanceof TreeLayout) {
            ((TreeLayout)layoutAlgorithm).setRootPredicate(null);
        }
        this.vv.getVisualizationModel().setGraph(this.tree, true);
        this.vv.repaint();
    }
}

