/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.task;

import ghidra.framework.task.GScheduledTask;
import ghidra.framework.task.GTaskGroup;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;

public class GTaskResult {
    private Exception exception;
    private int priority;
    private String description;
    private String groupDescription;
    private Integer transactionID;

    public GTaskResult(GTaskGroup group, GScheduledTask task, Exception e, Integer transactionID) {
        this.priority = task.getPriority();
        this.description = task.getDescription();
        this.groupDescription = task.getGroup().getDescription();
        this.exception = e;
        this.transactionID = transactionID;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean wasCancelled() {
        return this.exception instanceof CancelledException;
    }

    public Exception getException() {
        return this.exception;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getGroupDescription() {
        return this.groupDescription;
    }

    public boolean hasSameTransaction(GTaskResult result) {
        if (result == null) {
            return false;
        }
        return SystemUtilities.isEqual((Object)this.transactionID, (Object)result.transactionID);
    }

    public String toString() {
        return this.description;
    }
}

