/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.impl.dbgmodel.concept;

import agent.dbgmodel.dbgmodel.DbgModel;
import agent.dbgmodel.dbgmodel.debughost.DebugHostSymbolEnumerator;
import agent.dbgmodel.dbgmodel.debughost.DebugHostTypeSignature;
import agent.dbgmodel.dbgmodel.main.KeyStore;
import agent.dbgmodel.dbgmodel.main.ModelObject;
import agent.dbgmodel.impl.dbgmodel.concept.DataModelConceptInternal;
import agent.dbgmodel.jna.dbgmodel.concept.IDataModelConcept;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinNT;

public class DataModelConceptImpl
implements DataModelConceptInternal {
    private final DbgModel.OpaqueCleanable cleanable;
    private final IDataModelConcept jnaData;
    private KeyStore metadata;

    public DataModelConceptImpl(IDataModelConcept jnaData) {
        this.cleanable = DbgModel.releaseWhenPhantom((Object)this, jnaData);
        this.jnaData = jnaData;
    }

    @Override
    public Pointer getPointer() {
        return this.jnaData.getPointer();
    }

    @Override
    public void initializeObject(ModelObject modelObject, DebugHostTypeSignature matchingTypeSignature, DebugHostSymbolEnumerator wildcardMatches) {
        Pointer pModelObject = modelObject.getPointer();
        Pointer pMatchingTypeSignature = matchingTypeSignature.getPointer();
        Pointer pWildcardMatches = wildcardMatches.getPointer();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.InitializeObject(pModelObject, pMatchingTypeSignature, pWildcardMatches));
    }

    @Override
    public String getName() {
        WTypes.BSTRByReference bref = new WTypes.BSTRByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetName(bref));
        WTypes.BSTR bstr = bref.getValue();
        String modelName = bstr.getValue();
        OleAuto.INSTANCE.SysFreeString(bstr);
        return modelName;
    }

    @Override
    public KeyStore getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(KeyStore metdata) {
        this.metadata = metdata;
    }
}

