/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.manager.impl;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.ListeningConnector;
import ghidra.dbg.jdi.manager.JdiCause;
import ghidra.dbg.jdi.manager.JdiConsoleOutputListener;
import ghidra.dbg.jdi.manager.JdiEventHandler;
import ghidra.dbg.jdi.manager.JdiEventsListener;
import ghidra.dbg.jdi.manager.JdiManager;
import ghidra.dbg.jdi.manager.JdiStateListener;
import ghidra.dbg.jdi.manager.JdiTargetOutputListener;
import ghidra.dbg.jdi.manager.impl.DebugStatus;
import ghidra.lifecycle.Unfinished;
import ghidra.util.datastruct.ListenerSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.tuple.Pair;

public class JdiManagerImpl
implements JdiManager {
    public DebugStatus status;
    private VirtualMachineManager virtualMachineManager;
    private final Map<String, VirtualMachine> vms = new LinkedHashMap<String, VirtualMachine>();
    private VirtualMachine curVM = null;
    private final Map<String, VirtualMachine> unmodifiableVMs = Collections.unmodifiableMap(this.vms);
    protected final ListenerSet<JdiTargetOutputListener> listenersTargetOutput = new ListenerSet(JdiTargetOutputListener.class);
    protected final ListenerSet<JdiConsoleOutputListener> listenersConsoleOutput = new ListenerSet(JdiConsoleOutputListener.class);
    protected final ExecutorService eventThread = Executors.newSingleThreadExecutor();
    protected JdiEventHandler globalEventHandler = new JdiEventHandler();
    protected Map<VirtualMachine, JdiEventHandler> eventHandlers = new HashMap<VirtualMachine, JdiEventHandler>();
    protected Map<VirtualMachine, Connector> connectors = new HashMap<VirtualMachine, Connector>();

    public JdiManagerImpl() {
        this.virtualMachineManager = Bootstrap.virtualMachineManager();
    }

    public VirtualMachine connectVM(Connector cx, Map<String, Connector.Argument> arguments) throws Exception {
        if (cx instanceof LaunchingConnector) {
            LaunchingConnector lcx = (LaunchingConnector)cx;
            return lcx.launch(arguments);
        }
        if (cx instanceof AttachingConnector) {
            AttachingConnector acx = (AttachingConnector)cx;
            return acx.attach(arguments);
        }
        if (cx instanceof ListeningConnector) {
            ListeningConnector lcx = (ListeningConnector)cx;
            return lcx.accept(arguments);
        }
        throw new Exception("Unknown connector type");
    }

    @Override
    public void terminate() {
        for (VirtualMachine vm : this.vms.values()) {
            try {
                vm.dispose();
            }
            catch (VMDisconnectedException vMDisconnectedException) {}
        }
    }

    @Override
    public void addStateListener(VirtualMachine vm, JdiStateListener listener) {
        if (vm != null) {
            JdiEventHandler eventHandler = this.eventHandlers.get(vm);
            if (eventHandler != null) {
                eventHandler.addStateListener(listener);
            }
        } else {
            this.globalEventHandler.addStateListener(listener);
        }
    }

    @Override
    public void removeStateListener(VirtualMachine vm, JdiStateListener listener) {
        if (vm != null) {
            this.eventHandlers.get(vm).removeStateListener(listener);
        } else {
            this.globalEventHandler.removeStateListener(listener);
        }
    }

    @Override
    public void addEventsListener(VirtualMachine vm, JdiEventsListener listener) {
        if (vm != null) {
            this.eventHandlers.get(vm).addEventsListener(listener);
        } else {
            this.globalEventHandler.addEventsListener(listener);
        }
    }

    @Override
    public void removeEventsListener(VirtualMachine vm, JdiEventsListener listener) {
        if (vm != null) {
            this.eventHandlers.get(vm).removeEventsListener(listener);
        } else {
            this.globalEventHandler.removeEventsListener(listener);
        }
    }

    @Override
    public void addTargetOutputListener(JdiTargetOutputListener listener) {
        this.listenersTargetOutput.add((Object)listener);
    }

    @Override
    public void removeTargetOutputListener(JdiTargetOutputListener listener) {
        this.listenersTargetOutput.remove((Object)listener);
    }

    @Override
    public void addConsoleOutputListener(JdiConsoleOutputListener listener) {
        this.listenersConsoleOutput.add((Object)listener);
    }

    @Override
    public void removeConsoleOutputListener(JdiConsoleOutputListener listener) {
        this.listenersConsoleOutput.remove((Object)listener);
    }

    @Override
    public VirtualMachine getVM(String id) {
        return this.vms.get(id);
    }

    @Override
    public Map<String, VirtualMachine> getKnownVMs() {
        return this.unmodifiableVMs;
    }

    @Override
    public void sendInterruptNow() throws IOException {
        for (VirtualMachine vm : this.vms.values()) {
            for (ThreadReference thread : vm.allThreads()) {
                thread.interrupt();
            }
        }
    }

    @Override
    public CompletableFuture<VirtualMachine> addVM(Connector cx, List<String> args) {
        Map<String, Connector.Argument> arguments = cx.defaultArguments();
        if (cx instanceof LaunchingConnector) {
            if (arguments.containsKey("command")) {
                arguments.get("command").setValue(args.get(0));
            } else {
                arguments.get("main").setValue(args.get(0));
            }
        }
        if (cx instanceof AttachingConnector) {
            if (arguments.containsKey("pid")) {
                arguments.get("pid").setValue("" + Integer.decode(args.get(0)));
            } else if (args.size() == 2) {
                arguments.get("hostname").setValue(args.get(0));
                arguments.get("port").setValue(args.get(1));
            } else {
                arguments.get("port").setValue(args.get(0));
            }
        }
        if (cx instanceof ListeningConnector) {
            arguments.get("port").setValue("0");
            arguments.get("localAddress").setValue("localhost");
        }
        return this.addVM(cx, arguments);
    }

    @Override
    public CompletableFuture<VirtualMachine> addVM(Connector cx, Map<String, Connector.Argument> args) {
        try {
            this.curVM = this.connectVM(cx, args);
            JdiEventHandler eventHandler = new JdiEventHandler(this.curVM, this.globalEventHandler);
            eventHandler.start();
            eventHandler.setState(5, JdiCause.Causes.UNCLAIMED);
            this.eventHandlers.put(this.curVM, eventHandler);
            this.vms.put(this.curVM.name(), this.curVM);
            this.connectors.put(this.curVM, cx);
        }
        catch (VMDisconnectedException e) {
            System.out.println("Virtual Machine is disconnected.");
            return CompletableFuture.failedFuture(e);
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
        return CompletableFuture.completedFuture(this.curVM);
    }

    @Override
    public CompletableFuture<Void> removeVM(VirtualMachine vm) {
        if (this.curVM == vm) {
            this.curVM = null;
        }
        this.vms.remove(vm.name());
        this.connectors.remove(vm);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> console(String command) {
        return (CompletableFuture)Unfinished.TODO();
    }

    @Override
    public CompletableFuture<String> consoleCapture(String command) {
        return (CompletableFuture)Unfinished.TODO();
    }

    @Override
    public CompletableFuture<Map<String, VirtualMachine>> listVMs() {
        return CompletableFuture.completedFuture(this.vms);
    }

    @Override
    @Deprecated(forRemoval=true)
    public CompletableFuture<List<Pair<Integer, String>>> listAvailableProcesses() {
        ArrayList processes = new ArrayList();
        return CompletableFuture.completedFuture(processes);
    }

    @Override
    public VirtualMachineManager getVirtualMachineManager() {
        return this.virtualMachineManager;
    }

    public Connector getConnector(VirtualMachine vm) {
        return this.connectors.get(vm);
    }

    @Override
    public JdiEventHandler getEventHandler(VirtualMachine vm) {
        return this.eventHandlers.get(vm);
    }
}

