/*
 * Decompiled with CFR 0.152.
 */
package ghidra.test.processors.support;

import ghidra.test.processors.support.PCodeTestGroupControlBlock;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;

public class PCodeTestResults {
    private String jUnitName;
    boolean summaryHasIngestErrors;
    boolean summaryHasRelocationErrors;
    boolean summaryHasDisassemblyErrors;
    int summaryTotalAsserts;
    int summaryPassCount;
    int summaryFailCount;
    int summaryCallOtherCount;
    int summarySevereFailures;
    long time;
    private Map<String, TestResults> results = new HashMap<String, TestResults>();
    private static DateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm");
    private static String XML_VERSION = "1";
    public static String TAG_NAME = "PCodeTestResults";

    PCodeTestResults(String jUnitName) {
        this.jUnitName = jUnitName;
        this.time = System.currentTimeMillis();
    }

    public String getJUnitName() {
        return this.jUnitName;
    }

    public String getTime() {
        if (this.time == 0L) {
            return null;
        }
        Date d = new Date(this.time);
        return dateFormat.format(d);
    }

    public int getNumberOfTests() {
        return this.results.size();
    }

    public Collection<String> getGroupTestNames() {
        return this.results.keySet();
    }

    private String getGroupTestName(String groupName, String testName) {
        if (testName.endsWith(PCodeTestGroupControlBlock.TEST_GROUP_FUNCTION_SUFFIX)) {
            testName = testName.substring(0, testName.length() - PCodeTestGroupControlBlock.TEST_GROUP_FUNCTION_SUFFIX.length());
        }
        return groupName.replaceAll("\\d*$", "") + "." + testName;
    }

    TestResults getTestResults(String groupTestName, boolean create) {
        TestResults testResults = this.results.get(groupTestName);
        if (testResults == null && create) {
            testResults = new TestResults();
            this.results.put(groupTestName, testResults);
        }
        return testResults;
    }

    void declareTest(String groupName, String testName, int totalAsserts) {
        String groupTestName = this.getGroupTestName(groupName, testName);
        this.getTestResults((String)groupTestName, (boolean)true).totalAsserts = totalAsserts;
        this.summaryTotalAsserts += totalAsserts;
    }

    public int getTotalAsserts(String groupName, String testName) {
        String groupTestName = this.getGroupTestName(groupName, testName);
        TestResults testResults = this.getTestResults(groupTestName, false);
        if (testResults != null) {
            return testResults.totalAsserts;
        }
        return 0;
    }

    void addPassResult(String groupName, String testName) {
        String groupTestName = this.getGroupTestName(groupName, testName);
        ++this.getTestResults((String)groupTestName, (boolean)true).passCount;
        ++this.summaryPassCount;
    }

    public int getPassResult(String groupName, String testName) {
        String groupTestName = this.getGroupTestName(groupName, testName);
        TestResults testResults = this.getTestResults(groupTestName, false);
        if (testResults != null) {
            return testResults.passCount;
        }
        return 0;
    }

    void addFailResult(String groupName, String testName) {
        String groupTestName = this.getGroupTestName(groupName, testName);
        ++this.getTestResults((String)groupTestName, (boolean)true).failCount;
        ++this.summaryFailCount;
    }

    public int getFailResult(String groupName, String testName) {
        String groupTestName = this.getGroupTestName(groupName, testName);
        TestResults testResults = this.getTestResults(groupTestName, false);
        if (testResults != null) {
            return testResults.failCount;
        }
        return 0;
    }

    void addSevereFailResult(String groupName, String testName) {
        String groupTestName = this.getGroupTestName(groupName, testName);
        this.getTestResults((String)groupTestName, (boolean)true).severeFailure = true;
        ++this.summarySevereFailures;
    }

    public boolean hadSevereFailure(String groupName, String testName) {
        String groupTestName = this.getGroupTestName(groupName, testName);
        TestResults testResults = this.getTestResults(groupTestName, false);
        if (testResults != null) {
            return testResults.severeFailure;
        }
        return false;
    }

    void addCallOtherResult(String groupName, String testName) {
        String groupTestName = this.getGroupTestName(groupName, testName);
        ++this.getTestResults((String)groupTestName, (boolean)true).callOtherCount;
        ++this.summaryCallOtherCount;
    }

    public int getCallOtherResult(String groupName, String testName) {
        String groupTestName = this.getGroupTestName(groupName, testName);
        TestResults testResults = this.getTestResults(groupTestName, false);
        if (testResults != null) {
            return testResults.callOtherCount;
        }
        return 0;
    }

    void clear() {
        this.results.clear();
        this.summaryHasIngestErrors = false;
        this.summaryHasRelocationErrors = false;
        this.summaryHasDisassemblyErrors = false;
        this.summaryTotalAsserts = 0;
        this.summaryPassCount = 0;
        this.summaryFailCount = 0;
        this.summaryCallOtherCount = 0;
        this.summarySevereFailures = 0;
        this.time = System.currentTimeMillis();
    }

    public PCodeTestResults(Element root) {
        if (!TAG_NAME.equals(root.getName())) {
            throw new IllegalArgumentException("Unsupported root element: " + root.getName());
        }
        String ver = root.getAttributeValue("VERSION");
        if (!XML_VERSION.equals(ver)) {
            throw new IllegalArgumentException("Unsupported XML format version " + ver + ", required format is " + XML_VERSION);
        }
        this.jUnitName = root.getAttributeValue("JUNIT");
        this.time = 0L;
        String timeStr = root.getAttributeValue("TIME");
        if (timeStr != null) {
            try {
                this.time = Long.parseLong(timeStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.summaryHasIngestErrors = this.getAttributeValue(root, "INGEST_ERR", false);
        this.summaryHasRelocationErrors = this.getAttributeValue(root, "RELOC_ERR", false);
        this.summaryHasDisassemblyErrors = this.getAttributeValue(root, "DIS_ERR", false);
        List elementList = root.getChildren("TestResults");
        for (Element element : elementList) {
            String testName = element.getAttributeValue("NAME");
            if (testName == null) {
                throw new IllegalArgumentException("Invalid TestResults element in XML");
            }
            TestResults testResults = new TestResults();
            testResults.totalAsserts = this.getAttributeValue(element, "TOTAL_ASSERTS", 0);
            testResults.passCount = this.getAttributeValue(element, "PASS", 0);
            testResults.failCount = this.getAttributeValue(element, "FAIL", 0);
            testResults.callOtherCount = this.getAttributeValue(element, "CALLOTHER", 0);
            testResults.severeFailure = this.getAttributeValue(element, "SEVERE_FAILURE", false);
            this.summaryTotalAsserts += testResults.totalAsserts;
            this.summaryPassCount += testResults.passCount;
            this.summaryFailCount += testResults.failCount;
            this.summaryCallOtherCount += testResults.callOtherCount;
            if (testResults.severeFailure) {
                ++this.summarySevereFailures;
            }
            this.results.put(testName, testResults);
        }
    }

    int getAttributeValue(Element element, String attrName, int defaultValue) {
        String val = element.getAttributeValue(attrName);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    boolean getAttributeValue(Element element, String attrName, boolean defaultValue) {
        String val = element.getAttributeValue(attrName);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Boolean.valueOf(val);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    Element saveToXml() {
        Element root = new Element("PCodeTestResults");
        root.setAttribute(new Attribute("VERSION", XML_VERSION));
        root.setAttribute(new Attribute("JUNIT", this.jUnitName));
        if (this.time != 0L) {
            root.setAttribute(new Attribute("TIME", Long.toString(this.time)));
        }
        if (this.summaryHasIngestErrors) {
            root.setAttribute(new Attribute("INGEST_ERR", "TRUE"));
        }
        if (this.summaryHasRelocationErrors) {
            root.setAttribute(new Attribute("RELOC_ERR", "TRUE"));
        }
        if (this.summaryHasDisassemblyErrors) {
            root.setAttribute(new Attribute("DIS_ERR", "TRUE"));
        }
        ArrayList<String> testNames = new ArrayList<String>(this.results.keySet());
        Collections.sort(testNames);
        for (String testName : testNames) {
            TestResults testResults = this.results.get(testName);
            Element element = new Element("TestResults");
            element.setAttribute(new Attribute("NAME", testName));
            element.setAttribute(new Attribute("TOTAL_ASSERTS", Integer.toString(testResults.totalAsserts)));
            element.setAttribute(new Attribute("PASS", Integer.toString(testResults.passCount)));
            element.setAttribute(new Attribute("FAIL", Integer.toString(testResults.failCount)));
            element.setAttribute(new Attribute("CALLOTHER", Integer.toString(testResults.callOtherCount)));
            if (testResults.severeFailure) {
                element.setAttribute(new Attribute("SEVERE_FAILURE", "TRUE"));
            }
            root.addContent((Content)element);
        }
        return root;
    }

    static class TestResults {
        int totalAsserts;
        int passCount;
        int failCount;
        int callOtherCount;
        boolean severeFailure = false;

        TestResults() {
        }

        public String toString() {
            return "{" + this.passCount + "/" + this.failCount + "/" + this.callOtherCount + "(" + this.totalAsserts + ")}";
        }
    }
}

