/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugin.importer;

import ghidra.app.services.ProgramManager;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.framework.main.AppInfo;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectData;
import ghidra.framework.model.ProjectDataUtils;
import ghidra.framework.options.Options;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.datastruct.FixedSizeHashMap;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ProgramMappingService {
    public static final String PROGRAM_METADATA_MD5 = "Executable MD5";
    public static final String PROGRAM_SOURCE_FSRL = "FSRL";
    private static final int FSRL_TO_PATH_MAP_SIZE = 1000;
    private static Map<FSRL, String> fsrlToProjectPathMap = new FixedSizeHashMap(1000);

    private ProgramMappingService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map<FSRL, String> map = fsrlToProjectPathMap;
        synchronized (map) {
            fsrlToProjectPathMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFileOpen(FSRL fsrl) {
        String expectedMD5 = fsrl.getMD5();
        List<DomainFile> openDomainFiles = ProgramMappingService.findOpenFiles();
        Object consumer = new Object();
        for (DomainFile df : openDomainFiles) {
            DomainObject openedDomainObject = df.getOpenedDomainObject(consumer);
            try {
                if (!(openedDomainObject instanceof Program)) continue;
                Program program = (Program)openedDomainObject;
                Options propertyList = program.getOptions("Program Information");
                String fsrlStr = propertyList.getString(PROGRAM_SOURCE_FSRL, null);
                String md5 = propertyList.getString(PROGRAM_METADATA_MD5, null);
                if ((expectedMD5 == null || !expectedMD5.equals(md5)) && !fsrl.isEquivalent(fsrlStr)) continue;
                ProgramMappingService.createAssociation(fsrl, program);
                boolean bl = true;
                return bl;
            }
            finally {
                if (openedDomainObject == null || !openedDomainObject.isUsedBy(consumer)) continue;
                openedDomainObject.release(consumer);
            }
        }
        return false;
    }

    public static boolean isFileImportedIntoProject(FSRL fsrl) {
        return ProgramMappingService.isFileOpen(fsrl) || ProgramMappingService.getCachedDomainFileFor(fsrl) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DomainFile getCachedDomainFileFor(FSRL fsrl) {
        String path = null;
        Map<FSRL, String> map = fsrlToProjectPathMap;
        synchronized (map) {
            path = fsrlToProjectPathMap.get(fsrl);
            if (path == null && fsrl.getMD5() != null) {
                fsrl = fsrl.withMD5(null);
                path = fsrlToProjectPathMap.get(fsrl);
            }
        }
        if (path == null) {
            return null;
        }
        DomainFile domainFile = ProgramMappingService.getProjectFile(path);
        if (domainFile == null) {
            Map<FSRL, String> map2 = fsrlToProjectPathMap;
            synchronized (map2) {
                if (Objects.equals(fsrlToProjectPathMap.get(fsrl), path)) {
                    fsrlToProjectPathMap.remove(fsrl);
                }
            }
        }
        return domainFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createAssociation(FSRL fsrl, Program program) {
        Map<FSRL, String> map = fsrlToProjectPathMap;
        synchronized (map) {
            fsrlToProjectPathMap.put(fsrl, program.getDomainFile().getPathname());
            fsrlToProjectPathMap.put(fsrl.withMD5(null), program.getDomainFile().getPathname());
        }
    }

    public static void createAssociation(FSRL fsrl, DomainFile domainFile) {
        ProgramMappingService.createAssociation(fsrl, domainFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createAssociation(FSRL fsrl, DomainFile domainFile, boolean onlyAddIfEnoughRoomInCache) {
        Map<FSRL, String> map = fsrlToProjectPathMap;
        synchronized (map) {
            if (!onlyAddIfEnoughRoomInCache || fsrlToProjectPathMap.size() < 1000) {
                fsrlToProjectPathMap.put(fsrl, domainFile.getPathname());
                fsrlToProjectPathMap.put(fsrl.withMD5(null), domainFile.getPathname());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createAutoAssocation(Program program) {
        Options propertyList;
        String fsrlStr;
        if (program != null && (fsrlStr = (propertyList = program.getOptions("Program Information")).getString(PROGRAM_SOURCE_FSRL, null)) != null) {
            try {
                FSRL fsrl = FSRL.fromString(fsrlStr);
                Map<FSRL, String> map = fsrlToProjectPathMap;
                synchronized (map) {
                    if (!fsrlToProjectPathMap.containsKey(fsrl)) {
                        fsrlToProjectPathMap.put(fsrl, program.getDomainFile().getPathname());
                    }
                }
            }
            catch (MalformedURLException e) {
                Msg.error(ProgramMappingService.class, (Object)("Bad FSRL found: " + fsrlStr + ", program: " + program.getDomainFile().getPathname()));
            }
        }
    }

    public static Program findMatchingProgramOpenIfNeeded(FSRL fsrl, Object consumer, ProgramManager programManager, int openState) {
        return ProgramMappingService.findMatchingProgramOpenIfNeeded(fsrl, null, consumer, programManager, openState);
    }

    public static Program findMatchingProgramOpenIfNeeded(FSRL fsrl, DomainFile domainFile, Object consumer, ProgramManager programManager, int openState) {
        DomainFile df;
        Program program = ProgramMappingService.findMatchingOpenProgram(fsrl, consumer);
        if (program != null) {
            programManager.openProgram(program, openState);
            return program;
        }
        DomainFile domainFile2 = df = domainFile == null ? ProgramMappingService.getCachedDomainFileFor(fsrl) : domainFile;
        if (df == null || programManager == null) {
            return null;
        }
        program = programManager.openProgram(df, -1, openState);
        if (program != null) {
            program.addConsumer(consumer);
        }
        return program;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Program findMatchingOpenProgram(FSRL fsrl, Object consumer) {
        String expectedMD5 = fsrl.getMD5();
        Object tmpConsumer = new Object();
        List<DomainFile> openDomainFiles = ProgramMappingService.getOpenFiles();
        for (DomainFile df : openDomainFiles) {
            DomainObject openedDomainObject = df.getOpenedDomainObject(tmpConsumer);
            try {
                if (!(openedDomainObject instanceof Program)) continue;
                Program program = (Program)openedDomainObject;
                Options propertyList = program.getOptions("Program Information");
                String fsrlStr = propertyList.getString(PROGRAM_SOURCE_FSRL, null);
                String md5 = propertyList.getString(PROGRAM_METADATA_MD5, null);
                if ((expectedMD5 == null || !expectedMD5.equals(md5)) && !fsrl.isEquivalent(fsrlStr)) continue;
                df.getOpenedDomainObject(consumer);
                Program program2 = program;
                return program2;
            }
            finally {
                if (openedDomainObject == null) continue;
                openedDomainObject.release(tmpConsumer);
            }
        }
        return null;
    }

    public static Map<FSRL, DomainFile> searchProjectForMatchingFiles(List<FSRL> fsrls, TaskMonitor monitor) {
        Map<String, FSRL> fsrlsToFindByMD5;
        Project project = AppInfo.getActiveProject();
        if (project == null) {
            return Collections.emptyMap();
        }
        ProjectData projectData = project.getProjectData();
        int fc = projectData.getFileCount();
        if (fc > 0) {
            monitor.setShowProgressValue(true);
            monitor.setMaximum((long)fc);
            monitor.setProgress(0L);
        } else {
            monitor.setIndeterminate(true);
        }
        monitor.setMessage("Searching project for matching files");
        try {
            fsrlsToFindByMD5 = ProgramMappingService.buildFullyQualifiedFSRLMap(fsrls, monitor);
        }
        catch (CancelledException ce) {
            Msg.info(ProgramMappingService.class, (Object)"Canceling project search");
            return Collections.emptyMap();
        }
        HashMap<FSRL, DomainFile> results = new HashMap<FSRL, DomainFile>();
        Iterable files = ProjectDataUtils.descendantFiles((DomainFolder)projectData.getRootFolder());
        for (DomainFile domainFile : files) {
            FSRL matchedFSRL;
            String dfMD5;
            if (monitor.isCancelled() || fsrlsToFindByMD5.isEmpty()) break;
            monitor.incrementProgress(1L);
            Map metadata = domainFile.getMetadata();
            FSRL dfFSRL = ProgramMappingService.getFSRLFromMetadata(metadata, domainFile);
            if (dfFSRL != null) {
                ProgramMappingService.createAssociation(dfFSRL, domainFile, true);
            }
            if ((dfMD5 = dfFSRL != null ? dfFSRL.getMD5() : ProgramMappingService.getMD5FromMetadata(metadata)) == null || (matchedFSRL = fsrlsToFindByMD5.get(dfMD5)) == null) continue;
            results.put(matchedFSRL, domainFile);
            fsrlsToFindByMD5.remove(dfMD5);
        }
        return results;
    }

    private static String getMD5FromMetadata(Map<String, String> metadata) {
        return metadata.get(PROGRAM_METADATA_MD5);
    }

    private static FSRL getFSRLFromMetadata(Map<String, String> metadata, DomainFile domainFile) {
        String dfFSRLStr = metadata.get(PROGRAM_SOURCE_FSRL);
        if (dfFSRLStr != null) {
            try {
                FSRL dfFSRL = FSRL.fromString(dfFSRLStr);
                return dfFSRL;
            }
            catch (MalformedURLException e) {
                Msg.warn(ProgramMappingService.class, (Object)("Domain file " + domainFile.getPathname() + " has a bad FSRL: " + dfFSRLStr));
            }
        }
        return null;
    }

    private static DomainFile getProjectFile(String path) {
        ProjectData data;
        Project project = AppInfo.getActiveProject();
        if (project != null && (data = project.getProjectData()) != null) {
            return data.getFile(path);
        }
        return null;
    }

    private static List<DomainFile> getOpenFiles() {
        List<Object> files = new ArrayList<DomainFile>();
        Project project = AppInfo.getActiveProject();
        if (project != null) {
            files = project.getOpenData();
        }
        return files;
    }

    private static List<DomainFile> findOpenFiles() {
        ProjectData data;
        ArrayList<DomainFile> files = new ArrayList<DomainFile>();
        Project project = AppInfo.getActiveProject();
        if (project != null && (data = project.getProjectData()) != null) {
            data.findOpenFiles(files);
        }
        return files;
    }

    private static Map<String, FSRL> buildFullyQualifiedFSRLMap(List<FSRL> fsrls, TaskMonitor monitor) throws CancelledException {
        HashMap<String, FSRL> result = new HashMap<String, FSRL>();
        for (FSRL fsrl : fsrls) {
            try {
                FSRL fqFSRL = FileSystemService.getInstance().getFullyQualifiedFSRL(fsrl, monitor);
                String expectedMD5 = fqFSRL.getMD5();
                result.put(expectedMD5, fsrl);
            }
            catch (IOException iOException) {}
        }
        return result;
    }
}

