/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import generic.jar.ResourceFile;
import ghidra.app.util.opinion.QueryOpinionServiceHandler;
import ghidra.app.util.opinion.QueryResult;
import ghidra.framework.Application;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageCompilerSpecQuery;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.util.DefaultLanguageService;
import ghidra.util.Msg;
import ghidra.xml.XmlPullParser;
import ghidra.xml.XmlPullParserFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class QueryOpinionService {
    private static boolean doInit = true;
    private static Map<String, Map<String, Map<String, Set<QueryResult>>>> DATABASE = null;
    private static LanguageService languageService = null;

    private static synchronized void initialize() {
        if (doInit) {
            DATABASE = new HashMap<String, Map<String, Map<String, Set<QueryResult>>>>();
            languageService = DefaultLanguageService.getLanguageService();
            List<ResourceFile> files = QueryOpinionService.searchAndFindAllOpinionXMLs();
            for (ResourceFile file : files) {
                try {
                    QueryOpinionService.parseFile(file);
                }
                catch (Exception e) {
                    Msg.warn(QueryOpinionService.class, (Object)("Problem parsing " + file), (Throwable)e);
                }
            }
            doInit = false;
        }
    }

    private static List<ResourceFile> searchAndFindAllOpinionXMLs() {
        return Application.findFilesByExtensionInApplication((String)".opinion");
    }

    private static void parseFile(final ResourceFile file) throws SAXException, IOException {
        ErrorHandler errHandler = new ErrorHandler(){

            @Override
            public void error(SAXParseException exception) throws SAXException {
                Msg.error(QueryOpinionService.class, (Object)("Error parsing " + file), (Throwable)exception);
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                Msg.error(QueryOpinionService.class, (Object)("Fatal error parsing " + file), (Throwable)exception);
            }

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                Msg.warn(QueryOpinionService.class, (Object)("Warning parsing " + file), (Throwable)exception);
            }
        };
        XmlPullParser parser = XmlPullParserFactory.create((ResourceFile)file, (ErrorHandler)errHandler, (boolean)false);
        try {
            QueryOpinionServiceHandler.read(parser);
        }
        finally {
            parser.dispose();
        }
    }

    static void addQuery(String loader, String primary, String secondary, LanguageCompilerSpecQuery query) {
        Set<QueryResult> specs;
        Map<String, Set<QueryResult>> loaders;
        Map<String, Map<String, Set<QueryResult>>> loadersByName = DATABASE.get(loader);
        if (loadersByName == null) {
            loadersByName = new HashMap<String, Map<String, Set<QueryResult>>>();
            DATABASE.put(loader, loadersByName);
        }
        if ((loaders = loadersByName.get(primary)) == null) {
            loaders = new HashMap<String, Set<QueryResult>>();
            loadersByName.put(primary, loaders);
        }
        if ((specs = loaders.get(secondary)) == null) {
            specs = new HashSet<QueryResult>();
            loaders.put(secondary, specs);
        }
        LanguageCompilerSpecQuery broadQuery = new LanguageCompilerSpecQuery(query.processor, query.endian, query.size, query.variant, null);
        List pairs = languageService.getLanguageCompilerSpecPairs(broadQuery);
        for (LanguageCompilerSpecPair pair : pairs) {
            specs.add(new QueryResult(pair, pair.compilerSpecID.equals((Object)query.compilerSpecID)));
        }
    }

    public static List<QueryResult> query(String loaderName, String primaryKey, String secondaryKey) {
        QueryOpinionService.initialize();
        ArrayList<QueryResult> results = new ArrayList<QueryResult>();
        String message = "No query results found for loader " + loaderName + " with primary key " + primaryKey + " and secondary key " + secondaryKey;
        Map<String, Map<String, Set<QueryResult>>> loadersByName = DATABASE.get(loaderName);
        if (loadersByName == null) {
            Msg.debug(QueryOpinionService.class, (Object)message);
            return results;
        }
        Map<String, Set<QueryResult>> loadersById = QueryOpinionService.getPrimaryLoaders(loadersByName, primaryKey);
        if (loadersById == null) {
            Msg.debug(QueryOpinionService.class, (Object)message);
            return results;
        }
        QueryOpinionService.getSpecs(loadersById, secondaryKey, results);
        if (results.isEmpty()) {
            Msg.debug(QueryOpinionService.class, (Object)message);
        }
        return results;
    }

    private static void getSpecs(Map<String, Set<QueryResult>> loadersById, String secondaryKey, List<QueryResult> results) {
        Set<QueryResult> secondarySpecs = loadersById.get(secondaryKey);
        if (secondarySpecs == null) {
            secondarySpecs = QueryOpinionService.getQueryResultWithSecondaryMasking(secondaryKey, loadersById);
        }
        if (secondarySpecs == null) {
            secondarySpecs = loadersById.get(null);
        }
        if (secondarySpecs != null) {
            results.addAll(secondarySpecs);
        }
    }

    private static Map<String, Set<QueryResult>> getPrimaryLoaders(Map<String, Map<String, Set<QueryResult>>> loadersByName, String primaryKey) {
        Map<String, Set<QueryResult>> loadersById = loadersByName.get(primaryKey);
        if (loadersById != null) {
            return loadersById;
        }
        for (String primaryKeyOriginal : loadersByName.keySet()) {
            String[] tokens;
            if (primaryKeyOriginal == null) continue;
            String primaryKeyCleaned = primaryKeyOriginal.replaceAll("\\s+", "");
            for (String token : tokens = primaryKeyCleaned.split(",")) {
                if (!token.equals(primaryKey)) continue;
                return loadersByName.get(primaryKeyOriginal);
            }
        }
        return loadersById;
    }

    public static Set<QueryResult> getQueryResultWithSecondaryMasking(String secondaryKey, Map<String, Set<QueryResult>> byPrimary) {
        HashSet<QueryResult> queryResult = new HashSet<QueryResult>();
        for (Map.Entry<String, Set<QueryResult>> entry : byPrimary.entrySet()) {
            String secondaryAttributeString = entry.getKey();
            if (!QueryOpinionService.secondaryAttributeMatches(secondaryKey, secondaryAttributeString)) continue;
            queryResult.addAll((Collection<QueryResult>)entry.getValue());
        }
        if (queryResult.isEmpty()) {
            queryResult = null;
        }
        return queryResult;
    }

    static boolean secondaryAttributeMatches(String eFlagsDecimalString, String attribute) {
        if (attribute == null) {
            return false;
        }
        if (!StringUtils.startsWithAny((CharSequence)attribute.toLowerCase(), (CharSequence[])new CharSequence[]{"0x", "0b"})) {
            return false;
        }
        int eFlagsInt = Integer.parseInt(eFlagsDecimalString);
        String eFlagsBinaryString = Integer.toBinaryString(eFlagsInt);
        if (eFlagsBinaryString == null) {
            return false;
        }
        eFlagsBinaryString = StringUtils.leftPad((String)eFlagsBinaryString, (int)32, (String)"0");
        String eFlagsHexString = Integer.toHexString(eFlagsInt);
        eFlagsHexString = StringUtils.leftPad((String)eFlagsHexString, (int)8, (String)"0");
        String cleaned = attribute.replace("_", "").replaceAll("\\s+", "").trim();
        String prefix = cleaned.substring(0, 2);
        String value = cleaned.substring(2);
        if (prefix.toLowerCase().startsWith("0x")) {
            value = StringUtils.leftPad((String)value, (int)8, (String)"0");
            return value.equals(eFlagsHexString);
        }
        value = StringUtils.leftPad((String)value, (int)32, (String)"0");
        for (int i = 0; i < 32; ++i) {
            char c = value.charAt(i);
            if (c == '.' || eFlagsBinaryString.charAt(i) == c) continue;
            return false;
        }
        return true;
    }
}

